/*
 * Decompiled with CFR 0.152.
 */
package cn.pomit.boot.monitor.ui;

import cn.pomit.boot.monitor.model.Application;
import cn.pomit.boot.monitor.model.Endpoints;
import cn.pomit.boot.monitor.model.Instance;
import cn.pomit.boot.monitor.model.Registration;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.endpoint.ExposableEndpoint;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.Link;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoint;
import org.springframework.boot.actuate.endpoint.web.WebOperation;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/monitor"})
public class ApplicationController {
    Collection<? extends ExposableEndpoint<?>> endpoints;
    @Value(value="${spring.application.name:localhost}")
    private String name;

    public ApplicationController(Collection<? extends ExposableEndpoint<?>> endpoints) {
        this.endpoints = endpoints;
    }

    @ResponseBody
    @GetMapping(path={"/applications"}, produces={"application/json"})
    public List<Application> applications(HttpServletRequest request, HttpServletResponse response) {
        String normalizedUrl = this.normalizeRequestUrl(request);
        LinkedHashMap<String, Link> links = new LinkedHashMap<String, Link>();
        for (ExposableEndpoint<?> endpoint : this.endpoints) {
            if (endpoint instanceof ExposableWebEndpoint) {
                this.collectLinks(links, (ExposableWebEndpoint)endpoint, normalizedUrl);
                continue;
            }
            if (!(endpoint instanceof PathMappedEndpoint)) continue;
            links.put(endpoint.getId(), this.createLink(normalizedUrl, ((PathMappedEndpoint)endpoint).getRootPath()));
        }
        Application application = new Application();
        application.setName(this.name);
        Endpoints endpoints = new Endpoints(links);
        Registration registration = new Registration(this.name, normalizedUrl, normalizedUrl + "/health", this.hostUrl(request), "http-api");
        Instance instance = new Instance(this.name, registration, endpoints);
        application.setInstances(Arrays.asList(instance));
        return Arrays.asList(application);
    }

    @ResponseBody
    @GetMapping(path={"/applications"}, produces={"text/event-stream"})
    public List<ServerSentEvent<Application>> applicationsStream(HttpServletRequest request, HttpServletResponse response) {
        String normalizedUrl = this.normalizeRequestUrl(request);
        LinkedHashMap<String, Link> links = new LinkedHashMap<String, Link>();
        for (ExposableEndpoint<?> endpoint : this.endpoints) {
            if (endpoint instanceof ExposableWebEndpoint) {
                this.collectLinks(links, (ExposableWebEndpoint)endpoint, normalizedUrl);
                continue;
            }
            if (!(endpoint instanceof PathMappedEndpoint)) continue;
            links.put(endpoint.getId(), this.createLink(normalizedUrl, ((PathMappedEndpoint)endpoint).getRootPath()));
        }
        Application application = new Application();
        application.setName(this.name);
        Endpoints endpoints = new Endpoints(links);
        Registration registration = new Registration(this.name, normalizedUrl, normalizedUrl + "/health", this.hostUrl(request), "http-api");
        Instance instance = new Instance(this.name, registration, endpoints);
        application.setInstances(Arrays.asList(instance));
        return Arrays.asList(ServerSentEvent.builder((Object)application).build());
    }

    private String normalizeRequestUrl(HttpServletRequest request) {
        String uri = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        return uri + "actuator";
    }

    private String hostUrl(HttpServletRequest request) {
        String uri = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        return uri;
    }

    private void collectLinks(Map<String, Link> links, ExposableWebEndpoint endpoint, String normalizedUrl) {
        for (WebOperation operation : endpoint.getOperations()) {
            links.put(operation.getId(), this.createLink(normalizedUrl, operation));
        }
    }

    private Link createLink(String requestUrl, WebOperation operation) {
        return this.createLink(requestUrl, operation.getRequestPredicate().getPath());
    }

    private Link createLink(String requestUrl, String path) {
        return new Link(requestUrl + (path.startsWith("/") ? path : "/" + path));
    }
}

