/*
 * Decompiled with CFR 0.152.
 */
package cn.pomit.boot.monitor.configuration;

import cn.pomit.boot.monitor.event.InstanceEventLog;
import cn.pomit.boot.monitor.model.Application;
import cn.pomit.boot.monitor.model.UserInfo;
import cn.pomit.boot.monitor.ui.ApplicationController;
import cn.pomit.boot.monitor.ui.UiController;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.endpoint.web.WebEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.annotation.ServletEndpointsSupplier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.DigestUtils;

@Configuration
public class MonitorUiAutoConfiguration {
    @Value(value="${spring.application.name:localhost}")
    private String name;
    @Value(value="${spring.boot.monitor.username:#{null}}")
    private String userName;
    @Value(value="${spring.boot.monitor.password:#{null}}")
    private String password;
    @Value(value="${spring.boot.monitor.salt:pomit}")
    private String salt;

    @Bean
    @ConditionalOnMissingBean
    public UiController homeUiController() {
        return new UiController(this.userInfo());
    }

    @Bean
    public ApplicationController applicationController(WebEndpointsSupplier webEndpointsSupplier, ServletEndpointsSupplier servletEndpointsSupplier, ControllerEndpointsSupplier controllerEndpointsSupplier) {
        ArrayList allEndpoints = new ArrayList();
        Collection webEndpoints = webEndpointsSupplier.getEndpoints();
        allEndpoints.addAll(webEndpoints);
        allEndpoints.addAll(servletEndpointsSupplier.getEndpoints());
        allEndpoints.addAll(controllerEndpointsSupplier.getEndpoints());
        return new ApplicationController(allEndpoints, this.application(), this.instanceEventLog(), this.userInfo());
    }

    @Bean
    public InstanceEventLog instanceEventLog() {
        InstanceEventLog instanceEventLog = new InstanceEventLog();
        return instanceEventLog;
    }

    @Bean
    public Application application() {
        Application application = new Application();
        application.setName(this.name);
        return application;
    }

    @Bean
    public UserInfo userInfo() {
        UserInfo userInfo = new UserInfo();
        userInfo.setPassword(this.password);
        userInfo.setUserName(this.userName);
        userInfo.setSalt(this.salt);
        if (this.userName != null) {
            String userNameToken = DigestUtils.md5DigestAsHex((byte[])(this.userName + this.salt).getBytes());
            userInfo.setUserNameToken(userNameToken);
        }
        return userInfo;
    }
}

