/*
 * Decompiled with CFR 0.152.
 */
package cn.pomit.boot.monitor.model;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Registration
implements Serializable {
    private static final long serialVersionUID = -2685324097568177886L;
    private final String name;
    @Nullable
    private final String managementUrl;
    private final String healthUrl;
    @Nullable
    private final String serviceUrl;
    private final String source;
    private final Map<String, String> metadata;

    public Registration(String name, @Nullable String managementUrl, String healthUrl, @Nullable String serviceUrl, String source) {
        Assert.hasText((String)name, (String)"'name' must not be empty.");
        Assert.hasText((String)healthUrl, (String)"'healthUrl' must not be empty.");
        Assert.isTrue((boolean)this.checkUrl(healthUrl), (String)("'healthUrl' is not valid: " + healthUrl));
        Assert.isTrue((StringUtils.isEmpty((Object)managementUrl) || this.checkUrl(managementUrl) ? 1 : 0) != 0, (String)("'managementUrl' is not valid: " + managementUrl));
        Assert.isTrue((StringUtils.isEmpty((Object)serviceUrl) || this.checkUrl(serviceUrl) ? 1 : 0) != 0, (String)("'serviceUrl' is not valid: " + serviceUrl));
        this.name = name;
        this.managementUrl = managementUrl;
        this.healthUrl = healthUrl;
        this.serviceUrl = serviceUrl;
        this.source = source;
        this.metadata = new LinkedHashMap<String, String>();
        this.metadata.put("startup", Instant.now().toString());
    }

    public static Builder create(String name, String healthUrl) {
        return Registration.builder().name(name).healthUrl(healthUrl);
    }

    public static Builder copyOf(Registration registration) {
        return registration.toBuilder();
    }

    public Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    private boolean checkUrl(String url) {
        try {
            URI uri = new URI(url);
            return uri.isAbsolute();
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().name(this.name).managementUrl(this.managementUrl).healthUrl(this.healthUrl).serviceUrl(this.serviceUrl).source(this.source);
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getManagementUrl() {
        return this.managementUrl;
    }

    public String getHealthUrl() {
        return this.healthUrl;
    }

    @Nullable
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getSource() {
        return this.source;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Registration)) {
            return false;
        }
        Registration other = (Registration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$managementUrl = this.getManagementUrl();
        String other$managementUrl = other.getManagementUrl();
        if (this$managementUrl == null ? other$managementUrl != null : !this$managementUrl.equals(other$managementUrl)) {
            return false;
        }
        String this$healthUrl = this.getHealthUrl();
        String other$healthUrl = other.getHealthUrl();
        if (this$healthUrl == null ? other$healthUrl != null : !this$healthUrl.equals(other$healthUrl)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Registration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $managementUrl = this.getManagementUrl();
        result = result * 59 + ($managementUrl == null ? 43 : $managementUrl.hashCode());
        String $healthUrl = this.getHealthUrl();
        result = result * 59 + ($healthUrl == null ? 43 : $healthUrl.hashCode());
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public String toString() {
        return "Registration(name=" + this.getName() + ", managementUrl=" + this.getManagementUrl() + ", healthUrl=" + this.getHealthUrl() + ", serviceUrl=" + this.getServiceUrl() + ", source=" + this.getSource() + ")";
    }

    public static class Builder {
        private String name;
        private String managementUrl;
        private String healthUrl;
        private String serviceUrl;
        private String source;

        Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder managementUrl(@Nullable String managementUrl) {
            this.managementUrl = managementUrl;
            return this;
        }

        public Builder healthUrl(String healthUrl) {
            this.healthUrl = healthUrl;
            return this;
        }

        public Builder serviceUrl(@Nullable String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Registration build() {
            return new Registration(this.name, this.managementUrl, this.healthUrl, this.serviceUrl, this.source);
        }

        public String toString() {
            return "Registration.Builder(name=" + this.name + ", managementUrl=" + this.managementUrl + ", healthUrl=" + this.healthUrl + ", serviceUrl=" + this.serviceUrl + ", source=" + this.source + ")";
        }
    }
}

