/*
 * Decompiled with CFR 0.152.
 */
package cn.pomit.boot.monitor.ui;

import cn.pomit.boot.monitor.model.UserInfo;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class UiController {
    private UserInfo userInfo;

    public UiController() {
    }

    public UiController(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    @GetMapping(path={"/monitor"}, produces={"text/html"})
    public String index(@CookieValue(name="moni_id", required=false) String monitorId) {
        if (this.userInfo.getUserName() == null || this.userInfo.getPassword() == null) {
            return "redirect:/monitor/index.html";
        }
        if (monitorId != null && monitorId.equals(this.userInfo.getUserNameToken())) {
            return "redirect:/monitor/index.html";
        }
        return "redirect:/monitor/login.html";
    }

    @ResponseBody
    @GetMapping(path={"/monitor/context"})
    public String context(HttpServletRequest request) {
        String uri = request.getContextPath();
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        return uri;
    }

    @RequestMapping(value={"/monitor/login"})
    public String setCookies(@RequestParam(name="username", required=false) String reqUserName, @RequestParam(name="password", required=false) String reqPassword, HttpServletResponse response) {
        if (this.userInfo.getUserName() == null || this.userInfo.getPassword() == null) {
            return "redirect:/monitor/index.html";
        }
        if (reqUserName == null || reqPassword == null) {
            return "redirect:/monitor/login.html";
        }
        if (!StringUtils.isEmpty((Object)reqUserName) && !StringUtils.isEmpty((Object)reqPassword) && reqUserName.equals(this.userInfo.getUserName()) && reqPassword.equals(this.userInfo.getPassword())) {
            Cookie cookie = new Cookie("moni_id", this.userInfo.getUserNameToken());
            response.addCookie(cookie);
            return "redirect:/monitor/index.html";
        }
        return "redirect:/monitor/login.html";
    }
}

