/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail;

import com.acgist.snail.config.ConfigInitializer;
import com.acgist.snail.context.EntityInitializer;
import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.context.Initializer;
import com.acgist.snail.context.TaskContext;
import com.acgist.snail.context.TaskInitializer;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.net.NatInitializer;
import com.acgist.snail.net.application.ApplicationClient;
import com.acgist.snail.net.application.ApplicationServer;
import com.acgist.snail.net.torrent.TorrentInitializer;
import com.acgist.snail.net.torrent.dht.DhtInitializer;
import com.acgist.snail.net.torrent.lsd.LocalServiceDiscoveryInitializer;
import com.acgist.snail.net.torrent.tracker.TrackerInitializer;
import com.acgist.snail.protocol.Protocol;
import com.acgist.snail.protocol.ProtocolContext;
import com.acgist.snail.protocol.ftp.FtpProtocol;
import com.acgist.snail.protocol.hls.HlsProtocol;
import com.acgist.snail.protocol.http.HttpProtocol;
import com.acgist.snail.protocol.magnet.MagnetProtocol;
import com.acgist.snail.protocol.thunder.ThunderProtocol;
import com.acgist.snail.protocol.torrent.TorrentProtocol;
import java.util.ArrayList;
import java.util.List;

public final class Snail {
    private static final Logger LOGGER = LoggerFactory.getLogger(Snail.class);
    private static final Snail INSTANCE = new Snail();
    private boolean lock = false;
    private boolean buildTask = false;
    private boolean buildTorrent = false;
    private boolean buildApplication = false;
    private volatile boolean available = false;

    public static final Snail getInstance() {
        return INSTANCE;
    }

    private Snail() {
        EntityInitializer.newInstance().sync();
        ConfigInitializer.newInstance().sync();
    }

    public ITaskSession download(String url) throws DownloadException {
        return TaskContext.getInstance().download(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockDownload() {
        TaskContext context = TaskContext.getInstance();
        if (context.running()) {
            Snail snail = this;
            synchronized (snail) {
                this.lock = true;
                while (context.running()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOGGER.debug("\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38", e);
                    }
                }
                this.lock = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockDownload() {
        if (this.lock) {
            Snail snail = this;
            synchronized (snail) {
                this.notifyAll();
            }
        }
    }

    public static final boolean available() {
        return Snail.INSTANCE.available;
    }

    public static final void shutdown() {
        if (Snail.INSTANCE.available) {
            Snail.INSTANCE.available = false;
            if (Snail.INSTANCE.buildApplication) {
                ApplicationServer.getInstance().close();
            }
            TaskInitializer.newInstance().destroy();
            if (Snail.INSTANCE.buildTorrent) {
                NatInitializer.newInstance().destroy();
                DhtInitializer.newInstance().destroy();
                TorrentInitializer.newInstance().destroy();
                TrackerInitializer.newInstance().destroy();
                LocalServiceDiscoveryInitializer.newInstance().destroy();
            }
            EntityInitializer.newInstance().destroy();
        }
    }

    public static final class SnailBuilder {
        public static final SnailBuilder newBuilder() {
            return new SnailBuilder();
        }

        private SnailBuilder() {
        }

        public Snail buildSync() {
            return this.build(true);
        }

        public Snail buildAsyn() {
            return this.build(false);
        }

        public synchronized Snail build(boolean sync) {
            LOGGER.debug("\u521b\u5efaSnail\uff1a{}", sync);
            if (Snail.INSTANCE.available) {
                return INSTANCE;
            }
            Snail.INSTANCE.available = true;
            if (Snail.INSTANCE.buildApplication) {
                Snail.INSTANCE.available = ApplicationServer.getInstance().listen();
            }
            if (Snail.INSTANCE.available) {
                ProtocolContext.getInstance().available(Snail.INSTANCE.available);
                this.buildInitializerList().forEach(initializer -> {
                    if (sync) {
                        initializer.sync();
                    } else {
                        initializer.asyn();
                    }
                });
            } else {
                LOGGER.debug("\u5df2\u6709\u7cfb\u7edf\u5b9e\u4f8b\uff1a\u5524\u9192\u5b9e\u4f8b\u7a97\u53e3", new Object[0]);
                ApplicationClient.notifyWindow();
            }
            return INSTANCE;
        }

        private List<Initializer> buildInitializerList() {
            ArrayList<Initializer> list = new ArrayList<Initializer>();
            if (Snail.INSTANCE.buildTorrent) {
                list.add(NatInitializer.newInstance());
                list.add(DhtInitializer.newInstance());
                list.add(TorrentInitializer.newInstance());
                list.add(TrackerInitializer.newInstance());
                list.add(LocalServiceDiscoveryInitializer.newInstance());
            }
            if (Snail.INSTANCE.buildTask) {
                list.add(TaskInitializer.newInstance());
            }
            return list;
        }

        public SnailBuilder loadTask() {
            Snail.INSTANCE.buildTask = true;
            return this;
        }

        public SnailBuilder application() {
            Snail.INSTANCE.buildApplication = true;
            return this;
        }

        public SnailBuilder register(Protocol protocol) {
            ProtocolContext.getInstance().register(protocol);
            return this;
        }

        public SnailBuilder enableFtp() {
            return this.register(FtpProtocol.getInstance());
        }

        public SnailBuilder enableHls() {
            return this.register(HlsProtocol.getInstance());
        }

        public SnailBuilder enableHttp() {
            return this.register(HttpProtocol.getInstance());
        }

        public SnailBuilder enableMagnet() {
            Snail.INSTANCE.buildTorrent = true;
            return this.register(MagnetProtocol.getInstance());
        }

        public SnailBuilder enableThunder() {
            return this.register(ThunderProtocol.getInstance());
        }

        public SnailBuilder enableTorrent() {
            Snail.INSTANCE.buildTorrent = true;
            return this.register(TorrentProtocol.getInstance());
        }

        public SnailBuilder enableAllProtocol() {
            return this.enableFtp().enableHls().enableHttp().enableMagnet().enableThunder().enableTorrent();
        }
    }
}

