/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.config;

import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import java.math.BigInteger;

public final class CryptConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(CryptConfig.class);
    public static final BigInteger P = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A63A36210000000000090563", 16);
    public static final BigInteger G = BigInteger.valueOf(2L);
    public static final int PUBLIC_KEY_LENGTH = 96;
    public static final int PRIVATE_KEY_LENGTH = 128;
    public static final int PADDING_MAX_LENGTH = 512;
    public static final byte[] VC = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    public static final int VC_LENGTH = VC.length;
    public static final Strategy STRATEGY = Strategy.PREFER_PLAINTEXT;

    private CryptConfig() {
    }

    static {
        LOGGER.debug("MSE\u516c\u94a5\u957f\u5ea6\uff1a{}", 96);
        LOGGER.debug("MSE\u79c1\u94a5\u957f\u5ea6\uff1a{}", 128);
        LOGGER.debug("MSE\u9ed8\u8ba4\u52a0\u5bc6\u7b56\u7565\uff1a{}", new Object[]{STRATEGY});
    }

    public static enum Strategy {
        PLAINTEXT(false, CryptAlgo.PLAINTEXT.provide),
        PREFER_PLAINTEXT(false, CryptAlgo.PLAINTEXT.provide | CryptAlgo.ARC4.provide),
        PREFER_ENCRYPT(true, CryptAlgo.ARC4.provide | CryptAlgo.PLAINTEXT.provide),
        ENCRYPT(true, CryptAlgo.ARC4.provide);

        private final boolean crypt;
        private final int provide;

        private Strategy(boolean crypt, int provide) {
            this.crypt = crypt;
            this.provide = provide;
        }

        public final boolean getCrypt() {
            return this.crypt;
        }

        public final int getProvide() {
            return this.provide;
        }
    }

    public static enum CryptAlgo {
        PLAINTEXT(1),
        ARC4(2);

        private final int provide;

        private CryptAlgo(int provide) {
            this.provide = provide;
        }

        public final int getProvide() {
            return this.provide;
        }
    }
}

