/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.config;

import com.acgist.snail.config.PropertiesConfig;
import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.torrent.dht.NodeContext;
import com.acgist.snail.net.torrent.dht.NodeSession;
import com.acgist.snail.utils.StringUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class DhtConfig
extends PropertiesConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DhtConfig.class);
    public static final String DHT_CONFIG = "/config/bt.dht.properties";
    public static final byte DHT_HEADER = 100;
    public static final String KEY_T = "t";
    public static final String KEY_Y = "y";
    public static final String KEY_Q = "q";
    public static final String KEY_R = "r";
    public static final String KEY_A = "a";
    public static final String KEY_E = "e";
    public static final String KEY_V = "v";
    public static final String KEY_ID = "id";
    public static final String KEY_PORT = "port";
    public static final String KEY_TOKEN = "token";
    public static final String KEY_NODES = "nodes";
    public static final String KEY_NODES6 = "nodes6";
    public static final String KEY_WANT_N4 = "n4";
    public static final String KEY_WANT_N6 = "n6";
    public static final String KEY_WANT = "want";
    public static final String KEY_VALUES = "values";
    public static final String KEY_TARGET = "target";
    public static final String KEY_INFO_HASH = "info_hash";
    public static final String KEY_IMPLIED_PORT = "implied_port";
    public static final Integer IMPLIED_PORT_AUTO = 1;
    public static final Integer IMPLIED_PORT_CONFIG = 0;
    public static final int GET_PEER_SIZE = 32;
    public static final int NODE_ID_LENGTH = 20;
    public static final int MAX_NODE_SIZE = 1024;
    public static final int DHT_REQUEST_TIMEOUT_INTERVAL = 8;
    private final Map<String, String> nodes = new LinkedHashMap<String, String>();
    private static final DhtConfig INSTANCE = new DhtConfig();

    public static final DhtConfig getInstance() {
        return INSTANCE;
    }

    private DhtConfig() {
        super(DHT_CONFIG);
        this.init();
        this.release();
    }

    @Override
    public void init() {
        this.properties.entrySet().forEach(entry -> {
            String nodeId = (String)entry.getKey();
            String address = (String)entry.getValue();
            if (StringUtils.isNotEmpty(nodeId) && StringUtils.isNotEmpty(address)) {
                this.nodes.put(nodeId, address);
            } else {
                LOGGER.warn("\u9ed8\u8ba4DHT\u8282\u70b9\u6ce8\u518c\u5931\u8d25\uff1a{} - {}", nodeId, address);
            }
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u52a0\u8f7dDHT\u8282\u70b9\u6570\u91cf\uff1a{}", this.nodes.size());
        }
    }

    @Override
    public void persistent() {
        Map<String, String> data = NodeContext.getInstance().resize().stream().filter(NodeSession::useable).collect(Collectors.toMap(node -> StringUtils.hex(node.getId()), node -> SymbolConfig.Symbol.COLON.join(node.getHost(), node.getPort())));
        this.persistent(data, DHT_CONFIG);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u4fdd\u5b58DHT\u8282\u70b9\u6570\u91cf\uff1a{}", data.size());
        }
    }

    public Map<String, String> getNodes() {
        return this.nodes;
    }

    public static enum ErrorCode {
        CODE_201(201),
        CODE_202(202),
        CODE_203(203),
        CODE_204(204);

        private final int code;

        private ErrorCode(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static enum QType {
        PING("ping"),
        FIND_NODE("find_node"),
        GET_PEERS("get_peers"),
        ANNOUNCE_PEER("announce_peer");

        private final String value;

        private QType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static final QType of(String value) {
            QType[] types;
            for (QType type : types = QType.values()) {
                if (!type.value.equals(value)) continue;
                return type;
            }
            return null;
        }
    }
}

