/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.config;

import com.acgist.snail.config.PropertiesConfig;
import com.acgist.snail.context.TaskContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.utils.FileUtils;
import com.acgist.snail.utils.StringUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Objects;

public final class DownloadConfig
extends PropertiesConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadConfig.class);
    public static final String DOWNLOAD_CONFIG = "/config/download.properties";
    private static final int DOWNLOAD_UPLOAD_SCALE = 4;
    private static final String DOWNLOAD_PATH = "acgist.download.path";
    private static final String DOWNLOAD_SIZE = "acgist.download.size";
    private static final String DOWNLOAD_NOTICE = "acgist.download.notice";
    private static final String DOWNLOAD_DELETE = "acgist.download.delete";
    private static final String DOWNLOAD_BUFFER = "acgist.download.buffer";
    private static final String DOWNLOAD_LAST_PATH = "acgist.download.last.path";
    private static final String DOWNLOAD_MEMORY_BUFFER = "acgist.download.memory.buffer";
    private String path;
    private int size;
    private boolean notice;
    private boolean delete;
    private int buffer;
    private int uploadBufferByte;
    private int downloadBufferByte;
    private String lastPath;
    private int memoryBuffer;
    private int memoryBufferByte;
    private static final DownloadConfig INSTANCE = new DownloadConfig();

    public static final DownloadConfig getInstance() {
        return INSTANCE;
    }

    private DownloadConfig() {
        super(DOWNLOAD_CONFIG);
        this.init();
        this.release();
        this.refreshBuffer();
        this.refreshMemoryBuffer();
    }

    @Override
    public void init() {
        this.path = this.getString(DOWNLOAD_PATH);
        this.size = this.getInteger(DOWNLOAD_SIZE, 4);
        this.notice = this.getBoolean(DOWNLOAD_NOTICE, true);
        this.delete = this.getBoolean(DOWNLOAD_DELETE, false);
        this.buffer = this.getInteger(DOWNLOAD_BUFFER, 1024);
        this.lastPath = this.getString(DOWNLOAD_LAST_PATH);
        this.memoryBuffer = this.getInteger(DOWNLOAD_MEMORY_BUFFER, 8);
        LOGGER.debug("\u4e0b\u8f7d\u76ee\u5f55\uff1a{}", this.path);
        LOGGER.debug("\u4e0b\u8f7d\u6570\u91cf\uff1a{}", this.size);
        LOGGER.debug("\u6d88\u606f\u63d0\u793a\uff1a{}", this.notice);
        LOGGER.debug("\u5220\u9664\u6587\u4ef6\uff1a{}", this.delete);
        LOGGER.debug("\u4e0b\u8f7d\u901f\u5ea6\uff08\u5355\u4e2a\uff09\uff08KB\uff09\uff1a{}", this.buffer);
        LOGGER.debug("\u6700\u540e\u4e00\u6b21\u9009\u62e9\u76ee\u5f55\uff1a{}", this.lastPath);
        LOGGER.debug("\u78c1\u76d8\u7f13\u5b58\uff08\u5355\u4e2a\uff09\uff08MB\uff09\uff1a{}", this.memoryBuffer);
    }

    @Override
    public void persistent() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(DOWNLOAD_PATH, this.path);
        data.put(DOWNLOAD_SIZE, Objects.toString(this.size, "4"));
        data.put(DOWNLOAD_NOTICE, Objects.toString(this.notice, "true"));
        data.put(DOWNLOAD_DELETE, Objects.toString(this.delete, "false"));
        data.put(DOWNLOAD_BUFFER, Objects.toString(this.buffer, "1024"));
        data.put(DOWNLOAD_LAST_PATH, this.lastPath);
        data.put(DOWNLOAD_MEMORY_BUFFER, Objects.toString(this.memoryBuffer, "8"));
        this.persistent(data, DOWNLOAD_CONFIG);
    }

    public static final void setPath(String path) {
        if (StringUtils.equals(DownloadConfig.INSTANCE.path, path)) {
            return;
        }
        DownloadConfig.INSTANCE.path = path;
        INSTANCE.persistent();
    }

    public static final String getPath() {
        File file = new File(DownloadConfig.INSTANCE.path);
        if (file.exists() && file.isDirectory()) {
            return DownloadConfig.INSTANCE.path;
        }
        String path = FileUtils.userDir(DownloadConfig.INSTANCE.path);
        FileUtils.buildFolder(path);
        return path;
    }

    public static final String getPath(String fileName) {
        if (StringUtils.isEmpty(fileName)) {
            throw new IllegalArgumentException("\u6587\u4ef6\u540d\u79f0\u683c\u5f0f\u9519\u8bef\uff1a" + fileName);
        }
        return FileUtils.file(DownloadConfig.getPath(), fileName);
    }

    public static final void setSize(int size) {
        if (DownloadConfig.INSTANCE.size == size) {
            return;
        }
        DownloadConfig.INSTANCE.size = size;
        INSTANCE.persistent();
        TaskContext.getInstance().refresh();
    }

    public static final int getSize() {
        return DownloadConfig.INSTANCE.size;
    }

    public static final void setNotice(boolean notice) {
        if (DownloadConfig.INSTANCE.notice == notice) {
            return;
        }
        DownloadConfig.INSTANCE.notice = notice;
        INSTANCE.persistent();
    }

    public static final boolean getNotice() {
        return DownloadConfig.INSTANCE.notice;
    }

    public static final void setDelete(boolean delete) {
        if (DownloadConfig.INSTANCE.delete == delete) {
            return;
        }
        DownloadConfig.INSTANCE.delete = delete;
        INSTANCE.persistent();
    }

    public static final boolean getDelete() {
        return DownloadConfig.INSTANCE.delete;
    }

    public static final void setBuffer(int buffer) {
        if (DownloadConfig.INSTANCE.buffer == buffer) {
            return;
        }
        DownloadConfig.INSTANCE.buffer = buffer;
        INSTANCE.persistent();
        INSTANCE.refreshBuffer();
    }

    private void refreshBuffer() {
        this.downloadBufferByte = this.buffer * 1024;
        this.uploadBufferByte = this.downloadBufferByte / 4;
    }

    public static final int getBuffer() {
        return DownloadConfig.INSTANCE.buffer;
    }

    public static final int getUploadBufferByte() {
        return DownloadConfig.INSTANCE.uploadBufferByte;
    }

    public static final int getDownloadBufferByte() {
        return DownloadConfig.INSTANCE.downloadBufferByte;
    }

    public static final void setLastPath(String lastPath) {
        if (StringUtils.equals(DownloadConfig.INSTANCE.lastPath, lastPath)) {
            return;
        }
        DownloadConfig.INSTANCE.lastPath = lastPath;
        INSTANCE.persistent();
    }

    public static final String getLastPath() {
        if (StringUtils.isEmpty(DownloadConfig.INSTANCE.lastPath)) {
            return DownloadConfig.getPath();
        }
        File file = new File(DownloadConfig.INSTANCE.lastPath);
        if (file.exists() && file.isDirectory()) {
            return DownloadConfig.INSTANCE.lastPath;
        }
        return DownloadConfig.getPath();
    }

    public static final File getLastPathFile() {
        return new File(DownloadConfig.getLastPath());
    }

    public static final void setMemoryBuffer(int memoryBuffer) {
        if (DownloadConfig.INSTANCE.memoryBuffer == memoryBuffer) {
            return;
        }
        DownloadConfig.INSTANCE.memoryBuffer = memoryBuffer;
        INSTANCE.persistent();
        INSTANCE.refreshMemoryBuffer();
    }

    private void refreshMemoryBuffer() {
        this.memoryBufferByte = this.memoryBuffer * 0x100000;
    }

    public static final int getMemoryBuffer() {
        return DownloadConfig.INSTANCE.memoryBuffer;
    }

    public static final int getMemoryBufferByte() {
        return DownloadConfig.INSTANCE.memoryBufferByte;
    }

    public static final int getMemoryBufferByte(long fileSize) {
        int bufferSize = DownloadConfig.getMemoryBufferByte();
        if (fileSize > 0L) {
            if ((long)bufferSize > fileSize) {
                return (int)fileSize;
            }
            return bufferSize;
        }
        return bufferSize;
    }
}

