/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.config;

import com.acgist.snail.config.PropertiesConfig;
import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.utils.ArrayUtils;
import com.acgist.snail.utils.EnumUtils;
import com.acgist.snail.utils.PeerUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public final class PeerConfig
extends PropertiesConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeerConfig.class);
    public static final String UNKNOWN = "unknown";
    public static final int MAX_FAIL_TIMES = 3;
    public static final int PEER_ID_LENGTH = 20;
    public static final byte[] RESERVED = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    public static final int RESERVED_LENGTH = RESERVED.length;
    public static final byte RESERVED_DHT_PROTOCOL = 1;
    public static final byte RESERVED_PEER_EXCHANGE = 2;
    public static final byte RESERVED_FAST_PROTOCOL = 4;
    public static final byte RESERVED_NAT_TRAVERSAL = 8;
    public static final byte RESERVED_EXTENSION_PROTOCOL = 16;
    public static final int HANDSHAKE_LENGTH = 68;
    public static final String PROTOCOL_NAME = "BitTorrent protocol";
    public static final byte[] PROTOCOL_NAME_BYTES = "BitTorrent protocol".getBytes();
    public static final int PROTOCOL_NAME_LENGTH = PROTOCOL_NAME_BYTES.length;
    public static final byte STATUS_UPLOAD = 2;
    public static final byte STATUS_DOWNLOAD = 1;
    public static final byte PEX_PREFER_ENCRYPTION = 1;
    public static final byte PEX_UPLOAD_ONLY = 2;
    public static final byte PEX_UTP = 4;
    public static final byte PEX_HOLEPUNCH = 8;
    public static final byte PEX_OUTGO = 16;
    public static final long HOLEPUNCH_TIMEOUT = 2000L;
    public static final String CLIENT_NAME_CONFIG = "/config/client.name.properties";
    private static final Map<String, String> CLIENT_NAME_MAPPING = new HashMap<String, String>();
    private static final String PEER_ID_NAME = "AS";
    private static final int PEER_ID_VERSION_LENGTH = 4;
    private static final int PIECE_MIN = 0;
    private static final int PIECE_MAX = 32768;
    private final byte[] peerId = this.buildPeerId();
    private final String peerIdUrl = PeerUtils.urlEncode(this.peerId);
    private static final PeerConfig INSTANCE;

    public static final PeerConfig getInstance() {
        return INSTANCE;
    }

    private PeerConfig() {
        super(CLIENT_NAME_CONFIG);
        LOGGER.debug("PeerId\uff1a{}", new Object[]{this.peerId});
        LOGGER.debug("PeerIdUrl\uff1a{}", this.peerIdUrl);
        this.init();
        this.release();
    }

    @Override
    public void init() {
        this.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> CLIENT_NAME_MAPPING.put(key.toString(), value.toString())));
    }

    private byte[] buildPeerId() {
        byte[] peerId = new byte[20];
        StringBuilder builder = new StringBuilder(8);
        builder.append(SymbolConfig.Symbol.MINUS.toString()).append(PEER_ID_NAME);
        String version = SystemConfig.getVersion().replace(SymbolConfig.Symbol.DOT.toString(), "");
        int versionLength = version.length();
        if (versionLength > 4) {
            builder.append(version.substring(0, 4));
        } else {
            builder.append(version);
            builder.append(SymbolConfig.Symbol.ZERO.toString().repeat(4 - versionLength));
        }
        builder.append(SymbolConfig.Symbol.MINUS.toString());
        byte[] nameVersion = builder.toString().getBytes();
        int nameVersionLength = nameVersion.length;
        System.arraycopy(nameVersion, 0, peerId, 0, nameVersionLength);
        int paddingLength = 20 - nameVersionLength;
        byte[] padding = ArrayUtils.random(paddingLength);
        System.arraycopy(padding, 0, peerId, nameVersionLength, paddingLength);
        return peerId;
    }

    public byte[] getPeerId() {
        return this.peerId;
    }

    public String getPeerIdUrl() {
        return this.peerIdUrl;
    }

    public static final void enableNat() {
        RESERVED[7] = (byte)(RESERVED[7] | 8);
    }

    public static final boolean checkPiece(int index) {
        return index >= 0 && index <= 32768;
    }

    public static final String clientName(byte[] peerId) {
        if (peerId == null || peerId.length < 20) {
            return UNKNOWN;
        }
        char first = (char)peerId[0];
        String key = first == SymbolConfig.Symbol.MINUS.toChar() ? new String(peerId, 1, 2) : new String(peerId, 0, 1);
        return CLIENT_NAME_MAPPING.getOrDefault(key, UNKNOWN);
    }

    static {
        RESERVED[7] = (byte)(RESERVED[7] | 1);
        RESERVED[7] = (byte)(RESERVED[7] | 2);
        RESERVED[7] = (byte)(RESERVED[7] | 4);
        RESERVED[5] = (byte)(RESERVED[5] | 0x10);
        INSTANCE = new PeerConfig();
    }

    public static enum Action {
        MAGNET,
        TORRENT;

    }

    public static enum HolepunchErrorCode {
        CODE_00(0),
        CODE_01(1),
        CODE_02(2),
        CODE_03(3),
        CODE_04(4);

        private final byte code;

        private HolepunchErrorCode(byte code) {
            this.code = code;
        }

        public byte getCode() {
            return this.code;
        }
    }

    public static enum HolepunchType {
        RENDEZVOUS(0),
        CONNECT(1),
        ERROR(2);

        private final byte id;

        private HolepunchType(byte id) {
            this.id = id;
        }

        public byte getId() {
            return this.id;
        }

        public static final HolepunchType of(byte id) {
            HolepunchType[] types;
            for (HolepunchType type : types = HolepunchType.values()) {
                if (type.id != id) continue;
                return type;
            }
            return null;
        }
    }

    public static enum MetadataType {
        REQUEST(0),
        DATA(1),
        REJECT(2);

        private final byte id;

        private MetadataType(byte id) {
            this.id = id;
        }

        public byte getId() {
            return this.id;
        }

        public static final MetadataType of(byte id) {
            MetadataType[] types;
            for (MetadataType type : types = MetadataType.values()) {
                if (type.id != id) continue;
                return type;
            }
            return null;
        }
    }

    public static enum ExtensionType {
        HANDSHAKE(0, "handshake", true, false),
        UT_PEX(1, "ut_pex", true, true),
        UT_METADATA(2, "ut_metadata", true, true),
        UT_HOLEPUNCH(3, "ut_holepunch", true, true),
        UPLOAD_ONLY(4, "upload_only", true, true),
        LT_DONTHAVE(5, "lt_donthave", true, true);

        private final byte id;
        private final String value;
        private final boolean support;
        private final boolean notice;

        private ExtensionType(byte id, String value, boolean support, boolean notice) {
            this.id = id;
            this.value = value;
            this.support = support;
            this.notice = notice;
        }

        public byte getId() {
            return this.id;
        }

        public String getValue() {
            return this.value;
        }

        public boolean getSupport() {
            return this.support;
        }

        public boolean getNotice() {
            return this.notice;
        }

        public static final ExtensionType of(byte id) {
            ExtensionType[] types;
            for (ExtensionType type : types = ExtensionType.values()) {
                if (type.id != id) continue;
                return type;
            }
            return null;
        }

        public static final ExtensionType of(String value) {
            ExtensionType[] types;
            for (ExtensionType type : types = ExtensionType.values()) {
                if (!type.value.equalsIgnoreCase(value)) continue;
                return type;
            }
            return null;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Source {
        PEX(1),
        DHT(2),
        LSD(4),
        TRACKER(8),
        CONNECT(16),
        HOLEPUNCH(32);

        private final byte value;

        private Source(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public boolean preference() {
            return this == PEX || this == LSD || this == CONNECT;
        }
    }

    public static enum Type {
        CHOKE(0),
        UNCHOKE(1),
        INTERESTED(2),
        NOT_INTERESTED(3),
        HAVE(4),
        BITFIELD(5),
        REQUEST(6),
        PIECE(7),
        CANCEL(8),
        DHT(9),
        SUGGEST_PIECE(13),
        HAVE_ALL(14),
        HAVE_NONE(15),
        REJECT_REQUEST(16),
        ALLOWED_FAST(17),
        EXTENSION(20);

        private final byte id;
        private static final Type[] INDEX;

        private Type(byte id) {
            this.id = id;
        }

        public byte getId() {
            return this.id;
        }

        public static final Type of(byte id) {
            if (id < 0 || id >= INDEX.length) {
                return null;
            }
            return INDEX[id];
        }

        static {
            INDEX = EnumUtils.index(Type.class, Type::getId);
        }
    }
}

