/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.config;

import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.utils.FileUtils;
import com.acgist.snail.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;

public abstract class PropertiesConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesConfig.class);
    protected final Properties properties;

    protected PropertiesConfig(String path) {
        LOGGER.debug("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\uff1a{}", path);
        this.properties = PropertiesConfig.load(path);
    }

    private static final Properties load(String path) {
        Properties properties = PropertiesConfig.loadFromUserDir(path);
        if (properties == null) {
            properties = PropertiesConfig.loadFromResource(path);
        }
        if (properties == null) {
            LOGGER.warn("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff1a{}", path);
        }
        return properties;
    }

    private static final Properties loadFromUserDir(String path) {
        File file = FileUtils.userDirFile(path);
        if (file == null || !file.exists()) {
            return null;
        }
        Properties properties = null;
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            properties = new Properties();
            properties.load(reader);
        }
        catch (IOException e) {
            LOGGER.error("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38\uff1a{}", path, e);
        }
        return properties;
    }

    private static final Properties loadFromResource(String path) {
        if (PropertiesConfig.class.getResource(path) == null) {
            return null;
        }
        Properties properties = null;
        try (InputStreamReader reader = new InputStreamReader(PropertiesConfig.class.getResourceAsStream(path), StandardCharsets.UTF_8);){
            properties = new Properties();
            properties.load(reader);
        }
        catch (IOException e) {
            LOGGER.error("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38\uff1a{}", path, e);
        }
        return properties;
    }

    protected final void persistent(Map<String, String> data, String path) {
        if (data == null || path == null) {
            LOGGER.warn("\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff1a{} - {}", data, path);
            return;
        }
        File file = FileUtils.userDirFile(path);
        FileUtils.buildParentFolder(file);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            Properties properties = new Properties();
            properties.putAll(data);
            properties.store(writer, SystemConfig.getName());
        }
        catch (IOException e) {
            LOGGER.error("\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38\uff1a{}", file, e);
        }
    }

    protected final String getString(String name) {
        String value;
        String string = value = this.properties == null ? null : this.properties.getProperty(name);
        if (value == null) {
            LOGGER.debug("\u914d\u7f6e\u6ca1\u6709\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", name);
        }
        return value;
    }

    protected final String getString(String name, String defaultValue) {
        String value = this.getString(name);
        return value == null ? defaultValue : value;
    }

    protected final Boolean getBoolean(String name) {
        String value = this.getString(name);
        if (Boolean.TRUE.toString().equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        if (Boolean.FALSE.toString().equalsIgnoreCase(value)) {
            return Boolean.FALSE;
        }
        return null;
    }

    protected final boolean getBoolean(String name, boolean defaultValue) {
        Boolean value = this.getBoolean(name);
        return value == null ? defaultValue : value;
    }

    protected final Integer getInteger(String name) {
        String value = this.getString(name);
        if (StringUtils.isNumeric(value)) {
            return Integer.valueOf(value);
        }
        return null;
    }

    protected final int getInteger(String name, int defaultValue) {
        Integer value = this.getInteger(name);
        return value == null ? defaultValue : value;
    }

    public void init() {
    }

    public void persistent() {
    }

    protected final void release() {
        this.properties.clear();
    }
}

