/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.config;

public final class StunConfig {
    public static final int DEFAULT_PORT = 3478;
    public static final int MAGIC_COOKIE = 554869826;
    public static final int HEADER_STUN_LENGTH = 20;
    public static final int HEADER_ATTRIBUTE_LENGTH = 4;
    public static final int TRANSACTION_ID_LENGTH = 12;
    public static final int IPV4 = 1;
    public static final int IPV6 = 2;
    public static final byte STUN_HEADER_SEND = 0;
    public static final byte STUN_HEADER_RECV = 1;

    private StunConfig() {
    }

    public static enum ErrorCode {
        TRY_ALTERNATE(300),
        BAD_REQUEST(400),
        UNAUTHORIZED(401),
        UNKNOWN_ATTRIBUTE(420),
        STALE_NONCE(438),
        SERVER_ERROR(500);

        private final int code;

        private ErrorCode(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static enum AttributeType {
        MAPPED_ADDRESS(1),
        RESPONSE_ADDRESS(2),
        CHANGE_REQUEST(3),
        SOURCE_ADDRESS(4),
        CHANGED_ADDRESS(5),
        USERNAME(6),
        PASSWORD(7),
        MESSAGE_INTEGRITY(8),
        ERROR_CODE(9),
        UNKNOWN_ATTRIBUTES(10),
        REFLECTED_FROM(11),
        REALM(20),
        NONCE(21),
        XOR_MAPPED_ADDRESS(32),
        SOFTWARE(-32734),
        ALTERNATE_SERVER(-32733),
        FINGERPRINT(-32728);

        private final short id;

        private AttributeType(short id) {
            this.id = id;
        }

        public short getId() {
            return this.id;
        }

        public static final AttributeType of(short id) {
            AttributeType[] types;
            for (AttributeType attributeType : types = AttributeType.values()) {
                if (attributeType.id != id) continue;
                return attributeType;
            }
            return null;
        }
    }

    public static enum MessageType {
        REQUEST(0),
        INDICATION(1),
        RESPONSE_SUCCESS(2),
        RESPONSE_ERROR(3);

        public static final short C0_MASK = 16;
        public static final short C1_MASK = 256;
        public static final short TYPE_MASK = 16383;
        private final byte id;

        private MessageType(byte id) {
            this.id = id;
        }

        public byte getId() {
            return this.id;
        }

        public short of(MethodType methodType) {
            return (short)((this.id << 7 & 0x100 | this.id << 4 & 0x10 | methodType.id) & 0x3FFF);
        }

        public static final MessageType of(short value) {
            MessageType[] types;
            short type = (short)(value & 0x3FFF);
            byte id = (byte)((type & 0x100) >> 7 | (type & 0x10) >> 4);
            for (MessageType messageType : types = MessageType.values()) {
                if (messageType.id != id) continue;
                return messageType;
            }
            return null;
        }
    }

    public static enum MethodType {
        BINDING(1);

        public static final short MASK = 1;
        private final short id;

        private MethodType(short id) {
            this.id = id;
        }

        public short getId() {
            return this.id;
        }
    }
}

