/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.config;

import java.util.StringJoiner;

public final class SymbolConfig {
    public static final String LINE_SEPARATOR_COMPAT = Symbol.CARRIAGE_RETURN.toString() + Symbol.LINE_SEPARATOR.toString();

    private SymbolConfig() {
    }

    public static enum Symbol {
        OR('|'),
        AND('&'),
        DOT('.'),
        ZERO('0'),
        PLUS('+'),
        MINUS('-'),
        COLON(':'),
        COMMA(','),
        POUND('#'),
        SPACE(' '),
        SLASH('/'),
        BACKSLASH('\\'),
        EQUALS('='),
        PERCENT('%'),
        QUESTION('?'),
        SEMICOLON(';'),
        SINGLE_QUOTE('\''),
        DOUBLE_QUOTE('\"'),
        CARRIAGE_RETURN('\r'),
        LINE_SEPARATOR('\n'),
        OPEN_BRACE('{'),
        CLOSE_BRACE('}'),
        OPEN_BRACKET('['),
        CLOSE_BRACKET(']'),
        OPEN_PARENTHESIS('('),
        CLOSE_PARENTHESIS(')');

        private final char charValue;
        private final String stringValue;

        private Symbol(char value) {
            this.charValue = value;
            this.stringValue = Character.toString(value);
        }

        public String join(String ... args) {
            if (args == null) {
                return null;
            }
            StringJoiner joiner = new StringJoiner(this.stringValue);
            for (String object : args) {
                joiner.add(object);
            }
            return joiner.toString();
        }

        public String join(Object ... args) {
            if (args == null) {
                return null;
            }
            StringJoiner joiner = new StringJoiner(this.stringValue);
            for (Object object : args) {
                joiner.add(object == null ? null : object.toString());
            }
            return joiner.toString();
        }

        public final String[] split(String source) {
            return this.split(source, FullType.FILTER);
        }

        public final String[] split(String source, FullType type) {
            if (source == null) {
                return new String[0];
            }
            int size = 0;
            int left = 0;
            int index = 0;
            int length = this.stringValue.length();
            String[] array = new String[8];
            do {
                if ((index = source.indexOf(this.charValue, left)) < 0) {
                    array[size] = FullType.FILTER == type ? source.substring(left) : (FullType.PREFIX == type ? source.substring(left == 0 ? left : left) : source.substring(left == 0 ? left : left - length));
                } else {
                    array[size] = FullType.FILTER == type ? source.substring(left, index) : (FullType.PREFIX == type ? source.substring(left == 0 ? left : left, index + length) : source.substring(left == 0 ? left : left - length, index));
                    left = index + length;
                }
                if (++size < array.length) continue;
                String[] newArray = new String[size + 8];
                System.arraycopy(array, 0, newArray, 0, size);
                array = newArray;
            } while (index >= 0);
            String[] result = new String[size];
            System.arraycopy(array, 0, result, 0, size);
            return result;
        }

        public char toChar() {
            return this.charValue;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static interface BEncode {
        public static final char TYPE_E = 'e';
        public static final char TYPE_I = 'i';
        public static final char TYPE_L = 'l';
        public static final char TYPE_D = 'd';
        public static final char SEPARATOR = ':';
    }

    public static interface JSON {
        public static final char JSON_ESCAPE = '\\';
        public static final char JSON_MAP_PREFIX = '{';
        public static final char JSON_MAP_SUFFIX = '}';
        public static final char JSON_LIST_PREFIX = '[';
        public static final char JSON_LIST_SUFFIX = ']';
        public static final char JSON_KV_SEPARATOR = ':';
        public static final char JSON_ATTR_SEPARATOR = ',';
        public static final char JSON_STRING = '\"';
        public static final String JSON_NULL = "null";
        public static final String JSON_BOOLEAN_TRUE = "true";
        public static final String JSON_BOOLEAN_FALSE = "false";
    }

    public static enum FullType {
        FILTER,
        PREFIX,
        SUFFIX;

    }
}

