/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.config;

import com.acgist.snail.config.PropertiesConfig;
import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.utils.NetUtils;

public final class SystemConfig
extends PropertiesConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemConfig.class);
    public static final String SYSTEM_CONFIG = "/config/system.properties";
    public static final int PORT_LENGHT = 2;
    public static final int IPV4_LENGTH = 4;
    public static final int IPV6_LENGTH = 16;
    public static final int IPV4_PORT_LENGTH = 6;
    public static final int IPV6_PORT_LENGTH = 18;
    public static final int SHUTDOWN_FORCE_TIME = 30;
    public static final int DATA_SCALE = 1024;
    public static final int ONE_KB = 1024;
    public static final int ONE_MB = 0x100000;
    public static final int TCP_BUFFER_LENGTH = 16384;
    public static final int UDP_BUFFER_LENGTH = 2048;
    public static final int MAX_NET_BUFFER_LENGTH = 0x400000;
    public static final int MIN_DOWNLOAD_BUFFER_KB = 16;
    public static final int DEFAULT_EXCHANGE_LENGTH = 16384;
    public static final int DATE_SCALE = 1000;
    public static final int ONE_SECOND_MILLIS = 1000;
    public static final int NONE_TIMEOUT = 0;
    public static final int CONNECT_TIMEOUT = 5;
    public static final int CONNECT_TIMEOUT_MILLIS = 5000;
    public static final int RECEIVE_TIMEOUT = 5;
    public static final int RECEIVE_TIMEOUT_MILLIS = 5000;
    public static final int DOWNLOAD_TIMEOUT = 30;
    public static final int DOWNLOAD_TIMEOUT_MILLIS = 30000;
    public static final int REFRESH_INTERVAL = 5;
    public static final int REFRESH_INTERVAL_MILLIS = 5000;
    public static final int SHA1_HASH_LENGTH = 20;
    public static final String CHARSET_GBK = "GBK";
    public static final String CHARSET_UTF8 = "UTF-8";
    public static final String CHARSET_ASCII = "ASCII";
    public static final String CHARSET_ISO_8859_1 = "ISO-8859-1";
    public static final String DEFAULT_CHARSET = "UTF-8";
    private String name;
    private String nameEn;
    private String version;
    private String ftpUser;
    private String ftpPassword;
    private String author;
    private String source;
    private String support;
    private String latestRelease;
    private String stunServer;
    private int servicePort;
    private int torrentPort;
    private int torrentPortExt = 0;
    private int peerSize;
    private int trackerSize;
    private int pieceRepeatSize;
    private int dhtInterval;
    private int pexInterval;
    private int lsdInterval;
    private int haveInterval;
    private int stunInterval;
    private int trackerInterval;
    private int peerOptimizeInterval;
    private String nameEnAndVersion;
    private String externalIPAddress;
    private boolean externalIPAddressIPv4 = true;
    private static final SystemConfig INSTANCE = new SystemConfig();

    public static final SystemConfig getInstance() {
        return INSTANCE;
    }

    private SystemConfig() {
        super(SYSTEM_CONFIG);
        this.init();
        this.release();
    }

    @Override
    public void init() {
        this.name = this.getString("acgist.system.name");
        this.nameEn = this.getString("acgist.system.name.en");
        this.version = this.getString("acgist.system.version");
        this.ftpUser = this.getString("acgist.system.ftp.user");
        this.ftpPassword = this.getString("acgist.system.ftp.password");
        this.author = this.getString("acgist.system.author");
        this.source = this.getString("acgist.system.source");
        this.support = this.getString("acgist.system.support");
        this.latestRelease = this.getString("acgist.system.latest.release");
        this.stunServer = this.getString("acgist.system.stun.server");
        this.servicePort = this.getInteger("acgist.system.service.port", 16888);
        this.torrentPort = this.getInteger("acgist.system.torrent.port", 18888);
        this.peerSize = this.getInteger("acgist.system.peer.size", 20);
        this.trackerSize = this.getInteger("acgist.system.tracker.size", 50);
        this.pieceRepeatSize = this.getInteger("acgist.system.piece.repeat.size", 8);
        this.dhtInterval = this.getInteger("acgist.system.dht.interval", 120);
        this.pexInterval = this.getInteger("acgist.system.pex.interval", 120);
        this.lsdInterval = this.getInteger("acgist.system.lsd.interval", 120);
        this.haveInterval = this.getInteger("acgist.system.have.interval", 30);
        this.stunInterval = this.getInteger("acgist.system.stun.interval", 30);
        this.trackerInterval = this.getInteger("acgist.system.tracker.interval", 120);
        this.peerOptimizeInterval = this.getInteger("acgist.system.peer.optimize.interval", 60);
        this.nameEnAndVersion = SymbolConfig.Symbol.SPACE.join(this.nameEn, this.version);
        LOGGER.debug("\u8f6f\u4ef6\u540d\u79f0\uff1a{}", this.name);
        LOGGER.debug("\u8f6f\u4ef6\u540d\u79f0\uff08\u82f1\u6587\uff09\uff1a{}", this.nameEn);
        LOGGER.debug("\u8f6f\u4ef6\u7248\u672c\uff1a{}", this.version);
        LOGGER.debug("FTP\u533f\u540d\u7528\u6237\uff1a{}", this.ftpUser);
        LOGGER.debug("FTP\u533f\u540d\u5bc6\u7801\uff1a{}", this.ftpPassword);
        LOGGER.debug("\u4f5c\u8005\uff1a{}", this.author);
        LOGGER.debug("\u5b98\u7f51\u4e0e\u6e90\u7801\uff1a{}", this.source);
        LOGGER.debug("\u95ee\u9898\u4e0e\u5efa\u8bae\uff1a{}", this.support);
        LOGGER.debug("\u6700\u65b0\u7a33\u5b9a\u7248\u672c\uff1a{}", this.latestRelease);
        LOGGER.debug("STUN\u670d\u52a1\u5668\uff1a{}", this.stunServer);
        LOGGER.debug("\u7cfb\u7edf\u670d\u52a1\u7aef\u53e3\uff08\u672c\u5730\u670d\u52a1\uff1a\u542f\u52a8\u68c0\u6d4b\uff09\uff1a{}", this.servicePort);
        LOGGER.debug("BT\u670d\u52a1\u7aef\u53e3\uff08\u672c\u5730\u7aef\u53e3\uff1aPeer\u3001DHT\u3001UTP\u3001STUN\uff09\uff1a{}", this.torrentPort);
        LOGGER.debug("\u5355\u4e2a\u4efb\u52a1Peer\u6570\u91cf\uff08\u540c\u65f6\u4e0b\u8f7d\uff09\uff1a{}", this.peerSize);
        LOGGER.debug("\u5355\u4e2a\u4efb\u52a1Tracker\u6570\u91cf\uff1a{}", this.trackerSize);
        LOGGER.debug("\u4efb\u52a1\u5373\u5c06\u5b8c\u6210\u65f6\u53ef\u4ee5\u91cd\u590d\u4e0b\u8f7d\u7684Piece\u6570\u91cf\uff1a{}", this.pieceRepeatSize);
        LOGGER.debug("DHT\u6267\u884c\u5468\u671f\uff08\u79d2\uff09\uff1a{}", this.dhtInterval);
        LOGGER.debug("PEX\u6267\u884c\u5468\u671f\uff08\u79d2\uff09\uff1a{}", this.pexInterval);
        LOGGER.debug("\u672c\u5730\u53d1\u73b0\u6267\u884c\u5468\u671f\uff08\u79d2\uff09\uff1a{}", this.lsdInterval);
        LOGGER.debug("Have\u6d88\u606f\u6267\u884c\u5468\u671f\uff08\u79d2\uff09\uff1a{}", this.haveInterval);
        LOGGER.debug("Stun\u6d88\u606f\u6267\u884c\u5468\u671f\uff08\u79d2\uff09\uff1a{}", this.stunInterval);
        LOGGER.debug("Tracker\u6267\u884c\u5468\u671f\uff08\u79d2\uff09\uff1a{}", this.trackerInterval);
        LOGGER.debug("Peer\uff08\u8fde\u63a5\u3001\u63a5\u5165\uff09\u4f18\u5316\u5468\u671f\uff08\u79d2\uff09\uff1a{}", this.peerOptimizeInterval);
        LOGGER.debug("\u8f6f\u4ef6\u4fe1\u606f\uff1a{}", this.nameEnAndVersion);
    }

    public static final String getName() {
        return SystemConfig.INSTANCE.name;
    }

    public static final String getNameEn() {
        return SystemConfig.INSTANCE.nameEn;
    }

    public static final String getVersion() {
        return SystemConfig.INSTANCE.version;
    }

    public static final String getFtpUser() {
        return SystemConfig.INSTANCE.ftpUser;
    }

    public static final String getFtpPassword() {
        return SystemConfig.INSTANCE.ftpPassword;
    }

    public static final String getAuthor() {
        return SystemConfig.INSTANCE.author;
    }

    public static final String getSource() {
        return SystemConfig.INSTANCE.source;
    }

    public static final String getSupport() {
        return SystemConfig.INSTANCE.support;
    }

    public static final String getLatestRelease() {
        return SystemConfig.INSTANCE.latestRelease;
    }

    public static final String getStunServer() {
        return SystemConfig.INSTANCE.stunServer;
    }

    public static final int getServicePort() {
        return SystemConfig.INSTANCE.servicePort;
    }

    public static final int getTorrentPort() {
        return SystemConfig.INSTANCE.torrentPort;
    }

    public static final void setTorrentPort(int torrentPort) {
        SystemConfig.INSTANCE.torrentPort = torrentPort;
    }

    public static final int getTorrentPortExt() {
        if (SystemConfig.INSTANCE.torrentPortExt == 0) {
            return SystemConfig.getTorrentPort();
        }
        return SystemConfig.INSTANCE.torrentPortExt;
    }

    public static final void setTorrentPortExt(int torrentPortExt) {
        LOGGER.debug("\u8bbe\u7f6eBT\u670d\u52a1\u7aef\u53e3\uff08\u5916\u7f51\u7aef\u53e3\uff1aPeer\u3001DHT\u3001UTP\u3001STUN\uff09\uff1a{}", torrentPortExt);
        SystemConfig.INSTANCE.torrentPortExt = torrentPortExt;
    }

    public static final short getTorrentPortExtShort() {
        return NetUtils.portToShort(SystemConfig.getTorrentPortExt());
    }

    public static final int getPeerSize() {
        return SystemConfig.INSTANCE.peerSize;
    }

    public static final int getTrackerSize() {
        return SystemConfig.INSTANCE.trackerSize;
    }

    public static final int getPieceRepeatSize() {
        return SystemConfig.INSTANCE.pieceRepeatSize;
    }

    public static final int getDhtInterval() {
        return SystemConfig.INSTANCE.dhtInterval;
    }

    public static final int getPexInterval() {
        return SystemConfig.INSTANCE.pexInterval;
    }

    public static final int getLsdInterval() {
        return SystemConfig.INSTANCE.lsdInterval;
    }

    public static final int getHaveInterval() {
        return SystemConfig.INSTANCE.haveInterval;
    }

    public static final int getStunInterval() {
        return SystemConfig.INSTANCE.stunInterval;
    }

    public static final int getTrackerInterval() {
        return SystemConfig.INSTANCE.trackerInterval;
    }

    public static final int getPeerOptimizeInterval() {
        return SystemConfig.INSTANCE.peerOptimizeInterval;
    }

    public static final String getNameEnAndVersion() {
        return SystemConfig.INSTANCE.nameEnAndVersion;
    }

    public static final void setExternalIPAddress(String externalIPAddress) {
        LOGGER.debug("\u8bbe\u7f6e\u5916\u7f51IP\u5730\u5740\uff1a{}", externalIPAddress);
        SystemConfig.INSTANCE.externalIPAddress = externalIPAddress;
        SystemConfig.INSTANCE.externalIPAddressIPv4 = NetUtils.ipv4(externalIPAddress);
    }

    public static final String getExternalIPAddress() {
        return SystemConfig.INSTANCE.externalIPAddress;
    }

    public static final boolean getExternalIPAddressIPv4() {
        return SystemConfig.INSTANCE.externalIPAddressIPv4;
    }
}

