/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.config;

import com.acgist.snail.config.PropertiesConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.torrent.tracker.TrackerContext;
import com.acgist.snail.net.torrent.tracker.TrackerSession;
import com.acgist.snail.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public final class TrackerConfig
extends PropertiesConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrackerConfig.class);
    public static final String TRACKER_CONFIG = "/config/bt.tracker.properties";
    public static final int MAX_FAIL_TIMES = 3;
    public static final int MAX_TRACKER_SIZE = 512;
    private final List<String> announces = new ArrayList<String>();
    private static final TrackerConfig INSTANCE = new TrackerConfig();

    public static final TrackerConfig getInstance() {
        return INSTANCE;
    }

    private TrackerConfig() {
        super(TRACKER_CONFIG);
        this.init();
        this.release();
    }

    @Override
    public void init() {
        this.properties.entrySet().forEach(entry -> {
            String announce = (String)entry.getValue();
            if (StringUtils.isNotEmpty(announce)) {
                this.announces.add(announce);
            } else {
                LOGGER.warn("\u9ed8\u8ba4Tracker\u670d\u52a1\u5668\u6ce8\u518c\u5931\u8d25\uff1a{}", announce);
            }
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u52a0\u8f7dTracker\u670d\u52a1\u5668\u6570\u91cf\uff1a{}", this.announces.size());
        }
    }

    @Override
    public void persistent() {
        AtomicInteger index = new AtomicInteger(0);
        Map<String, String> data = TrackerContext.getInstance().sessions().stream().filter(TrackerSession::available).sorted().limit(512L).collect(Collectors.toMap(session -> String.format("%04d", index.incrementAndGet()), TrackerSession::announceUrl));
        this.persistent(data, TRACKER_CONFIG);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u4fdd\u5b58Tracker\u670d\u52a1\u5668\u6570\u91cf\uff1a{}", data.size());
        }
    }

    public List<String> getAnnounces() {
        return this.announces;
    }

    public static enum Event {
        NONE(0, "none"),
        COMPLETED(1, "completed"),
        STARTED(2, "started"),
        STOPPED(3, "stopped");

        private final int id;
        private final String value;

        private Event(int id, String value) {
            this.id = id;
            this.value = value;
        }

        public int getId() {
            return this.id;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Action {
        CONNECT(0, "connect"),
        ANNOUNCE(1, "announce"),
        SCRAPE(2, "scrape"),
        ERROR(3, "error");

        private final int id;
        private final String value;

        private Action(int id, String value) {
            this.id = id;
            this.value = value;
        }

        public int getId() {
            return this.id;
        }

        public String getValue() {
            return this.value;
        }

        public static final Action of(int id) {
            Action[] values;
            for (Action action : values = Action.values()) {
                if (action.id != id) continue;
                return action;
            }
            return null;
        }
    }
}

