/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.config;

import com.acgist.snail.utils.EnumUtils;

public final class UtpConfig {
    public static final byte VERSION = 1;
    public static final int HEADER_LENGTH = 20;
    public static final int HEADER_MIN_LENGTH = 20;
    public static final byte EXTENSION = 0;
    public static final int EXTENSION_MIN_LENGTH = 2;
    public static final int PACKET_MAX_LENGTH = 1452;
    public static final int WND_SIZE = 0x100000;
    public static final byte MAX_PUSH_TIMES = 3;
    public static final byte FAST_ACK_RETRY_TIMES = 3;

    private UtpConfig() {
    }

    public static enum Type {
        DATA(0),
        FIN(1),
        STATE(2),
        RESET(3),
        SYN(4);

        private final byte type;
        private final byte typeVersion;
        private static final Type[] INDEX;

        private Type(byte type) {
            this.type = type;
            this.typeVersion = (byte)(type << 4 | 1);
        }

        public byte getType() {
            return this.type;
        }

        public byte getTypeVersion() {
            return this.typeVersion;
        }

        public static final Type of(byte typeVersion) {
            byte value = (byte)(typeVersion >> 4);
            if (value < 0 || value >= INDEX.length) {
                return null;
            }
            return INDEX[value];
        }

        static {
            INDEX = EnumUtils.index(Type.class, Type::getType);
        }
    }
}

