/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.context;

import com.acgist.snail.config.DownloadConfig;
import com.acgist.snail.context.EntityException;
import com.acgist.snail.context.IContext;
import com.acgist.snail.context.entity.Entity;
import com.acgist.snail.context.entity.TaskEntity;
import com.acgist.snail.gui.recycle.RecycleContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public final class EntityContext
implements IContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityContext.class);
    private static final String ENTITY_FILE_PATH = "./config/snail.entities";
    private final List<Entity> allEntities = new ArrayList<Entity>();
    private static final EntityContext INSTANCE = new EntityContext();

    public static final EntityContext getInstance() {
        return INSTANCE;
    }

    private EntityContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Entity entity) {
        EntityException.requireNotNull(entity);
        EntityException.requireNull(entity.getId());
        entity.setId(UUID.randomUUID().toString());
        entity.setCreateDate(new Date());
        entity.setModifyDate(new Date());
        LOGGER.debug("\u4fdd\u5b58\u5b9e\u4f53\uff1a{}", entity);
        EntityContext entityContext = this;
        synchronized (entityContext) {
            this.allEntities.add(entity);
        }
        this.persistent();
    }

    public void update(Entity entity) {
        EntityException.requireNotNull(entity);
        EntityException.requireNotNull(entity.getId());
        entity.setModifyDate(new Date());
        LOGGER.debug("\u66f4\u65b0\u5b9e\u4f53\uff1a{}", entity);
        this.persistent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String id) {
        LOGGER.debug("\u5220\u9664\u5b9e\u4f53\uff1a{}", id);
        boolean success = false;
        EntityContext entityContext = this;
        synchronized (entityContext) {
            success = this.allEntities.removeIf(entity -> entity.getId().equals(id));
        }
        if (success) {
            this.persistent();
        } else {
            LOGGER.warn("\u5220\u9664\u5b9e\u4f53\u65e0\u6548\uff1a{}", id);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        File file = new File(ENTITY_FILE_PATH);
        if (!file.exists()) {
            LOGGER.debug("\u52a0\u8f7d\u5b9e\u4f53\u6587\u4ef6\u65e0\u6548\uff1a{}", file);
            return;
        }
        try (ObjectInputStream input = new ObjectInputStream(new FileInputStream(file));){
            List list = (List)input.readObject();
            EntityContext entityContext = this;
            synchronized (entityContext) {
                this.allEntities.clear();
                list.forEach(object -> {
                    if (object instanceof Entity) {
                        Entity entity = (Entity)object;
                        this.allEntities.add(entity);
                    } else {
                        LOGGER.warn("\u672a\u77e5\u5b9e\u4f53\u7c7b\u578b\uff1a{}", object);
                    }
                });
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("\u52a0\u8f7d\u5b9e\u4f53\u6570\u91cf\uff1a{}", this.allEntities.size());
                }
            }
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.error("\u52a0\u8f7d\u5b9e\u4f53\u5f02\u5e38", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistent() {
        ArrayList<Entity> list = new ArrayList<Entity>();
        EntityContext entityContext = this;
        synchronized (entityContext) {
            list.addAll(this.allEntities);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u4fdd\u5b58\u5b9e\u4f53\u6570\u91cf\uff1a{}", list.size());
        }
        File file = new File(ENTITY_FILE_PATH);
        FileUtils.buildParentFolder(file);
        try (ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(file));){
            output.writeObject(list);
        }
        catch (IOException e) {
            LOGGER.error("\u4fdd\u5b58\u5b9e\u4f53\u5f02\u5e38", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaskEntity> allTask() {
        EntityContext entityContext = this;
        synchronized (entityContext) {
            return this.allEntities.stream().map(v -> {
                if (v instanceof TaskEntity) {
                    TaskEntity entity = (TaskEntity)v;
                    return entity;
                }
                return null;
            }).filter(Objects::nonNull).toList();
        }
    }

    public boolean deleteTask(TaskEntity entity) {
        String file;
        EntityException.requireNotNull(entity);
        EntityException.requireNotNull(entity.getId());
        LOGGER.debug("\u5220\u9664\u4efb\u52a1\uff1a{} - {}", entity.getId(), entity.getName());
        if (DownloadConfig.getDelete() && !RecycleContext.recycle(file = entity.getFile())) {
            FileUtils.delete(file);
        }
        return this.delete(entity.getId());
    }
}

