/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.context;

import com.acgist.snail.context.IInitializer;
import com.acgist.snail.context.SystemThreadContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.net.NetException;
import java.util.concurrent.TimeUnit;

public abstract class Initializer
implements IInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Initializer.class);
    private final String name;
    private final int delay;

    protected Initializer(String name) {
        this(name, 0);
    }

    protected Initializer(String name, int delay) {
        this.name = name;
        this.delay = delay;
    }

    @Override
    public final void sync() {
        try {
            LOGGER.debug("\u540c\u6b65\u6267\u884c\u521d\u59cb\u5316\uff1a{}", this.name);
            this.init();
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u6b65\u6267\u884c\u521d\u59cb\u5316\u5f02\u5e38\uff1a{}", this.name, e);
        }
    }

    @Override
    public final void asyn() {
        Runnable runnable = () -> {
            try {
                LOGGER.debug("\u5f02\u6b65\u6267\u884c\u521d\u59cb\u5316\uff1a{} - {}", this.name, this.delay);
                this.init();
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u6b65\u6267\u884c\u521d\u59cb\u5316\u5f02\u5e38\uff1a{} - {}", this.name, this.delay, e);
            }
        };
        if (this.delay <= 0) {
            SystemThreadContext.submit(runnable);
        } else {
            SystemThreadContext.scheduled(this.delay, TimeUnit.SECONDS, runnable);
        }
    }

    @Override
    public final void destroy() {
        try {
            LOGGER.debug("\u6267\u884c\u9500\u6bc1\u65b9\u6cd5\uff1a{}", this.name);
            this.release();
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884c\u9500\u6bc1\u65b9\u6cd5\u5f02\u5e38\uff1a{}", this.name, e);
        }
    }

    protected abstract void init() throws NetException, DownloadException;

    protected abstract void release();
}

