/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.context;

import com.acgist.snail.Snail;
import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.context.IContext;
import com.acgist.snail.context.SystemThreadContext;
import com.acgist.snail.format.JSON;
import com.acgist.snail.gui.GuiContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.TcpClient;
import com.acgist.snail.net.TcpServer;
import com.acgist.snail.net.UdpServer;
import com.acgist.snail.net.http.HttpClient;
import com.acgist.snail.utils.FileUtils;
import java.util.concurrent.TimeUnit;

public final class SystemContext
implements IContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemContext.class);
    private final String osName = System.getProperty("os.name");
    private static final SystemContext INSTANCE = new SystemContext();

    public static final SystemContext getInstance() {
        return INSTANCE;
    }

    private SystemContext() {
    }

    public static final void gc() {
        LOGGER.info("\u6574\u7406\u7cfb\u7edf\u5185\u5b58", new Object[0]);
        System.gc();
    }

    public static final void info() {
        LOGGER.info("\n\n:: Snail : \u78a7\u87ba\u8427\u8427\n:: https://gitee.com/acgist/snail\n\n\u6708\u843d\u4e4c\u557c\u971c\u6ee1\u5929\uff0c\u6c5f\u67ab\u6e14\u706b\u5bf9\u6101\u7720\u3002\n\u59d1\u82cf\u57ce\u5916\u5bd2\u5c71\u5bfa\uff0c\u591c\u534a\u949f\u58f0\u5230\u5ba2\u8239\u3002\n", new Object[0]);
        Runtime runtime = Runtime.getRuntime();
        LOGGER.info("\u64cd\u4f5c\u7cfb\u7edf\u540d\u79f0\uff1a{}", System.getProperty("os.name"));
        LOGGER.info("\u64cd\u4f5c\u7cfb\u7edf\u67b6\u6784\uff1a{}", System.getProperty("os.arch"));
        LOGGER.info("\u64cd\u4f5c\u7cfb\u7edf\u7248\u672c\uff1a{}", System.getProperty("os.version"));
        LOGGER.info("\u64cd\u4f5c\u7cfb\u7edf\u53ef\u7528\u5904\u7406\u5668\u6570\u91cf\uff1a{}", runtime.availableProcessors());
        LOGGER.info("Java\u7248\u672c\uff1a{}", System.getProperty("java.version"));
        LOGGER.info("Java\u4e3b\u76ee\u5f55\uff1a{}", System.getProperty("java.home"));
        LOGGER.info("Java\u5e93\u76ee\u5f55\uff1a{}", System.getProperty("java.library.path"));
        LOGGER.info("Java\u4e34\u65f6\u6587\u4ef6\u76ee\u5f55\uff1a{}", System.getProperty("java.io.tmpdir"));
        LOGGER.info("Java Class\u76ee\u5f55\uff1a{}", System.getProperty("java.class.path"));
        LOGGER.info("\u865a\u62df\u673a\u540d\u79f0\uff1a{}", System.getProperty("java.vm.name"));
        LOGGER.info("\u865a\u62df\u673a\u7248\u672c\uff1a{}", System.getProperty("java.vm.version"));
        LOGGER.info("\u865a\u62df\u673a\u7a7a\u95f2\u5185\u5b58\uff1a{}", FileUtils.formatSize(runtime.freeMemory()));
        LOGGER.info("\u865a\u62df\u673a\u5df2\u7528\u5185\u5b58\uff1a{}", FileUtils.formatSize(runtime.totalMemory()));
        LOGGER.info("\u865a\u62df\u673a\u6700\u5927\u5185\u5b58\uff1a{}", FileUtils.formatSize(runtime.maxMemory()));
        LOGGER.info("\u865a\u62df\u673a\u8fd0\u884c\u65f6\u540d\u79f0\uff1a{}", System.getProperty("java.runtime.name"));
        LOGGER.info("\u865a\u62df\u673a\u8fd0\u884c\u65f6\u7248\u672c\uff1a{}", System.getProperty("java.runtime.version"));
        LOGGER.info("\u7528\u6237\u76ee\u5f55\uff1a{}", System.getProperty("user.home"));
        LOGGER.info("\u7528\u6237\u540d\u79f0\uff1a{}", System.getProperty("user.name"));
        LOGGER.info("\u7528\u6237\u56fd\u5bb6\uff1a{}", System.getProperty("user.country"));
        LOGGER.info("\u7528\u6237\u8bed\u8a00\uff1a{}", System.getProperty("user.language"));
        LOGGER.info("\u7528\u6237\u65f6\u533a\uff1a{}", System.getProperty("user.timezone"));
        LOGGER.info("\u7528\u6237\u5de5\u4f5c\u76ee\u5f55\uff1a{}", System.getProperty("user.dir"));
        LOGGER.info("\u6587\u4ef6\u7f16\u7801\uff1a{}", System.getProperty("file.encoding"));
        LOGGER.info("\u672c\u5730\u7f16\u7801\uff1a{}", System.getProperty("native.encoding"));
        LOGGER.info("CPU\u5927\u5c0f\u7aef\uff1a{}", System.getProperty("sun.cpu.endian"));
        LOGGER.info("CPU\u6307\u4ee4\u96c6\uff1a{}", System.getProperty("sun.cpu.isalist"));
    }

    public static final Snail build() {
        return Snail.SnailBuilder.newBuilder().loadTask().application().enableAllProtocol().buildAsyn();
    }

    public static final void shutdown() {
        if (Snail.available()) {
            SystemThreadContext.submit(() -> {
                LOGGER.info("\u7cfb\u7edf\u5173\u95ed\u4e2d", new Object[0]);
                GuiContext.getInstance().hide();
                GuiContext.getInstance().exit();
                Snail.shutdown();
                TcpClient.shutdown();
                TcpServer.shutdown();
                UdpServer.shutdown();
                SystemThreadContext.shutdown();
                LOGGER.info("\u7cfb\u7edf\u5df2\u5173\u95ed", new Object[0]);
                LoggerFactory.shutdown();
            });
            SystemThreadContext.scheduled(30L, TimeUnit.SECONDS, () -> {
                LOGGER.warn("\u7cfb\u7edf\u5f3a\u5236\u5173\u95ed", new Object[0]);
                LoggerFactory.shutdown();
                Runtime.getRuntime().halt(0);
            });
        } else {
            GuiContext.getInstance().alert("\u5173\u95ed\u63d0\u793a", "\u7cfb\u7edf\u5173\u95ed\u4e2d");
        }
    }

    public static final String osName() {
        return SystemContext.INSTANCE.osName;
    }

    public static final boolean latestRelease() {
        try {
            String version = SystemConfig.getVersion();
            String body = HttpClient.newInstance(SystemConfig.getLatestRelease()).get().responseToString();
            JSON json = JSON.ofString(body);
            String latestVersion = json.getString("tag_name");
            LOGGER.debug("\u7248\u672c\u4fe1\u606f\uff1a{} - {}", version, latestVersion);
            return latestVersion.equals(version);
        }
        catch (NetException e) {
            LOGGER.error("\u7248\u672c\u68c0\u67e5\u5f02\u5e38", e);
            GuiContext.getInstance().alert("\u7248\u672c\u68c0\u67e5\u5931\u8d25", e.getMessage());
            return true;
        }
    }

    public static enum SystemType {
        MAC("Mac OS", "Mac OS X"),
        LINUX("Linux"),
        WINDOWS("Windows XP", "Windows Vista", "Windows 7", "Windows 10");

        private final String[] osNames;

        private SystemType(String ... osNames) {
            this.osNames = osNames;
        }

        public static final SystemType local() {
            String osName = SystemContext.osName();
            for (SystemType type : SystemType.values()) {
                for (String value : type.osNames) {
                    if (!value.equals(osName)) continue;
                    return type;
                }
            }
            LOGGER.warn("\u672a\u77e5\u7cfb\u7edf\u7c7b\u578b\uff1a{}", osName);
            return null;
        }
    }
}

