/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.context;

import com.acgist.snail.context.IContext;
import com.acgist.snail.context.ScheduledException;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import java.nio.channels.AsynchronousChannelGroup;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class SystemThreadContext
implements IContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemThreadContext.class);
    public static final String SNAIL_THREAD = "ST";
    public static final String SNAIL_THREAD_BT = "ST-BT";
    public static final String SNAIL_THREAD_HLS = "ST-HLS";
    public static final String SNAIL_THREAD_COSTED = "ST-Costed";
    public static final String SNAIL_THREAD_SCHEDULED = "ST-Scheduled";
    public static final String SNAIL_THREAD_BT_SCHEDULED = "ST-BT-Scheduled";
    public static final String SNAIL_THREAD_UTP_QUEUE = "ST-UTP-Queue";
    public static final String SNAIL_THREAD_UDP_SERVER = "ST-UDP-Server";
    public static final String SNAIL_THREAD_TCP_CLIENT = "ST-TCP-Client";
    public static final String SNAIL_THREAD_TCP_SERVER = "ST-TCP-Server";
    public static final String SNAIL_THREAD_DOWNLOADER = "ST-Downloader";
    private static final ExecutorService EXECUTOR;
    private static final ScheduledExecutorService EXECUTOR_SCHEDULED;
    private static final int MAX_THREAD_INDEX = 99;
    private static final String THREAD_NAME = "%s-%02d";
    private static final Map<String, Integer> THREAD_INDEX_MAPPING;
    public static final int DEFAULT_THREAD_SIZE;

    private SystemThreadContext() {
    }

    public static final int threadSize(int minSize, int maxSize) {
        return DEFAULT_THREAD_SIZE < minSize ? minSize : (DEFAULT_THREAD_SIZE > maxSize ? maxSize : DEFAULT_THREAD_SIZE);
    }

    public static final void submit(Runnable runnable) {
        EXECUTOR.submit(runnable);
    }

    public static final ScheduledFuture<?> scheduled(long delay, TimeUnit unit, Runnable runnable) {
        ScheduledException.verify(delay);
        return EXECUTOR_SCHEDULED.schedule(runnable, delay, unit);
    }

    public static final ScheduledFuture<?> scheduledAtFixedRate(long delay, long period, TimeUnit unit, Runnable runnable) {
        ScheduledException.verify(delay);
        ScheduledException.verify(period);
        return EXECUTOR_SCHEDULED.scheduleAtFixedRate(runnable, delay, period, unit);
    }

    public static final ScheduledFuture<?> scheduledAtFixedDelay(long delay, long period, TimeUnit unit, Runnable runnable) {
        ScheduledException.verify(delay);
        ScheduledException.verify(period);
        return EXECUTOR_SCHEDULED.scheduleWithFixedDelay(runnable, delay, period, unit);
    }

    public static final ExecutorService newExecutor(int minPoolSize, int maxPoolSize, int queueSize, long keepAliveTime, String name) {
        LOGGER.debug("\u65b0\u5efa\u56fa\u5b9a\u7ebf\u7a0b\u6c60\uff1a{} - {} - {}", name, minPoolSize, maxPoolSize);
        return new ThreadPoolExecutor(minPoolSize, maxPoolSize, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueSize), SystemThreadContext.newThreadFactory(name), (runnable, executor) -> LOGGER.warn("\u62d2\u7edd\u6267\u884c\u4efb\u52a1\uff1a{} - {}", runnable, executor));
    }

    public static final ExecutorService newCacheExecutor(int minPoolSize, long keepAliveTime, String name) {
        LOGGER.debug("\u65b0\u5efa\u7f13\u5b58\u7ebf\u7a0b\u6c60\uff1a{} - {}", name, minPoolSize);
        return new ThreadPoolExecutor(minPoolSize, Short.MAX_VALUE, keepAliveTime, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), SystemThreadContext.newThreadFactory(name), (runnable, executor) -> LOGGER.warn("\u62d2\u7edd\u6267\u884c\u4efb\u52a1\uff1a{} - {}", runnable, executor));
    }

    public static final ScheduledExecutorService newScheduledExecutor(int minPoolSize, String name) {
        LOGGER.debug("\u65b0\u5efa\u5b9a\u65f6\u7ebf\u7a0b\u6c60\uff1a{} - {}", name, minPoolSize);
        return new ScheduledThreadPoolExecutor(minPoolSize, SystemThreadContext.newThreadFactory(name), (runnable, executor) -> LOGGER.warn("\u62d2\u7edd\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\uff1a{} - {}", runnable, executor));
    }

    private static final ThreadFactory newThreadFactory(String poolName) {
        return runnable -> {
            Thread thread = new Thread(runnable);
            int index = 0;
            Map<String, Integer> map = THREAD_INDEX_MAPPING;
            synchronized (map) {
                index = THREAD_INDEX_MAPPING.compute(poolName, (k, v) -> v == null || v >= 99 ? 1 : v + 1);
            }
            thread.setName(String.format(THREAD_NAME, poolName, index));
            thread.setDaemon(true);
            return thread;
        };
    }

    public static final void shutdown() {
        LOGGER.debug("\u5173\u95ed\u7cfb\u7edf\u7ebf\u7a0b\u6c60", new Object[0]);
        SystemThreadContext.shutdown(EXECUTOR);
        SystemThreadContext.shutdown(EXECUTOR_SCHEDULED);
    }

    public static final void shutdown(ExecutorService executor) {
        SystemThreadContext.shutdown(false, executor);
    }

    public static final void shutdownNow(ExecutorService executor) {
        SystemThreadContext.shutdown(true, executor);
    }

    private static final void shutdown(boolean closeNow, ExecutorService executor) {
        if (executor == null || executor.isShutdown()) {
            return;
        }
        try {
            if (closeNow) {
                executor.shutdownNow();
            } else {
                executor.shutdown();
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5173\u95ed\u7ebf\u7a0b\u6c60\u5f02\u5e38", e);
        }
    }

    public static final void shutdown(ScheduledFuture<?> scheduledFuture) {
        SystemThreadContext.shutdown(false, scheduledFuture);
    }

    public static final void shutdownNow(ScheduledFuture<?> scheduledFuture) {
        SystemThreadContext.shutdown(true, scheduledFuture);
    }

    private static final void shutdown(boolean closeNow, ScheduledFuture<?> scheduledFuture) {
        if (scheduledFuture == null || scheduledFuture.isCancelled()) {
            return;
        }
        try {
            scheduledFuture.cancel(closeNow);
        }
        catch (Exception e) {
            LOGGER.error("\u5173\u95ed\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38", e);
        }
    }

    public static final void shutdown(AsynchronousChannelGroup group) {
        SystemThreadContext.shutdown(false, group);
    }

    public static final void shutdownNow(AsynchronousChannelGroup group) {
        SystemThreadContext.shutdown(true, group);
    }

    private static final void shutdown(boolean closeNow, AsynchronousChannelGroup group) {
        if (group == null || group.isShutdown()) {
            return;
        }
        try {
            if (closeNow) {
                group.shutdownNow();
            } else {
                group.shutdown();
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5173\u95ed\u5f02\u6b65\u901a\u9053\u7ebf\u7a0b\u6c60\u5f02\u5e38", e);
        }
    }

    static {
        THREAD_INDEX_MAPPING = new HashMap<String, Integer>();
        DEFAULT_THREAD_SIZE = Runtime.getRuntime().availableProcessors();
        EXECUTOR = SystemThreadContext.newExecutor(SystemThreadContext.threadSize(4, 8), SystemThreadContext.threadSize(16, 32), Short.MAX_VALUE, 60L, SNAIL_THREAD);
        EXECUTOR_SCHEDULED = SystemThreadContext.newScheduledExecutor(SystemThreadContext.threadSize(2, 4), SNAIL_THREAD_SCHEDULED);
        LOGGER.info("\u7cfb\u7edf\u9ed8\u8ba4\u7ebf\u7a0b\u6570\u91cf\uff1a{}", DEFAULT_THREAD_SIZE);
    }
}

