/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.context;

import com.acgist.snail.config.DownloadConfig;
import com.acgist.snail.context.EntityContext;
import com.acgist.snail.context.IContext;
import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.context.ITaskSessionHandler;
import com.acgist.snail.context.ITaskSessionStatus;
import com.acgist.snail.context.SystemThreadContext;
import com.acgist.snail.context.entity.TaskEntity;
import com.acgist.snail.context.session.TaskSession;
import com.acgist.snail.gui.GuiContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.protocol.ProtocolContext;
import com.acgist.snail.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;

public final class TaskContext
implements IContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskContext.class);
    private final List<ITaskSession> tasks = new ArrayList<ITaskSession>(DownloadConfig.getSize());
    private final ExecutorService executor = SystemThreadContext.newCacheExecutor(0, 60L, "ST-Downloader");
    private static final TaskContext INSTANCE = new TaskContext();

    public static final TaskContext getInstance() {
        return INSTANCE;
    }

    private TaskContext() {
    }

    public ITaskSession download(String url) throws DownloadException {
        ITaskSession session = ProtocolContext.getInstance().buildTaskSession(url);
        session.start();
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(ITaskSession taskSession) throws DownloadException {
        if (taskSession == null) {
            throw new DownloadException("\u4efb\u52a1\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (ProtocolContext.getInstance().available()) {
            List<ITaskSession> list = this.tasks;
            synchronized (list) {
                taskSession.buildDownloader();
                if (this.tasks.contains(taskSession)) {
                    LOGGER.debug("\u4efb\u52a1\u5df2\u7ecf\u5b58\u5728\uff1a{}", taskSession);
                } else {
                    this.tasks.add(taskSession);
                }
            }
        } else {
            throw new DownloadException("\u4e0b\u8f7d\u534f\u8bae\u672a\u521d\u59cb\u5316");
        }
        GuiContext.getInstance().refreshTaskList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ITaskSession taskSession) {
        List<ITaskSession> list = this.tasks;
        synchronized (list) {
            LOGGER.debug("\u5220\u9664\u4e0b\u8f7d\u4efb\u52a1\uff1a{}", taskSession);
            this.tasks.remove(taskSession);
        }
        GuiContext.getInstance().refreshTaskList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ITaskSession> allTask() {
        List<ITaskSession> list = this.tasks;
        synchronized (list) {
            return this.tasks.stream().toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean running() {
        List<ITaskSession> list = this.tasks;
        synchronized (list) {
            return this.tasks.stream().anyMatch(ITaskSessionStatus::statusRunning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        List<ITaskSession> list = this.tasks;
        synchronized (list) {
            long downloadCount = this.tasks.stream().filter(ITaskSessionStatus::statusDownload).count();
            int downloadSize = DownloadConfig.getSize();
            if (downloadCount == (long)downloadSize) {
                LOGGER.debug("\u4e0b\u8f7d\u4efb\u52a1\u6570\u91cf\u6b63\u5e38\uff1a{} - {}", downloadSize, downloadCount);
            } else if (downloadCount > (long)downloadSize) {
                LOGGER.debug("\u6682\u505c\u90e8\u5206\u4e0b\u8f7d\u4efb\u52a1\uff1a{} - {}", downloadSize, downloadCount);
                this.tasks.stream().filter(ITaskSessionStatus::statusDownload).skip(downloadSize).forEach(ITaskSessionHandler::await);
            } else {
                LOGGER.debug("\u5f00\u59cb\u90e8\u5206\u4e0b\u8f7d\u4efb\u52a1\uff1a{} - {}", downloadSize, downloadCount);
                this.tasks.stream().filter(ITaskSessionStatus::statusAwait).limit((long)downloadSize - downloadCount).map(ITaskSession::getDownloader).forEach(this.executor::submit);
            }
        }
    }

    public void load() {
        List<TaskEntity> list = EntityContext.getInstance().allTask();
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(this::load);
            this.refresh();
        }
    }

    private void load(TaskEntity entity) {
        try {
            ITaskSession taskSession = TaskSession.newInstance(entity);
            taskSession.reset();
            this.submit(taskSession);
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u4e0b\u8f7d\u4efb\u52a1\u5f02\u5e38\uff1a{}", entity, e);
            EntityContext.getInstance().deleteTask(entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        LOGGER.debug("\u5173\u95ed\u4efb\u52a1\u4e0a\u4e0b\u6587", new Object[0]);
        List<ITaskSession> list = this.tasks;
        synchronized (list) {
            this.tasks.stream().filter(ITaskSessionStatus::statusRunning).forEach(ITaskSessionHandler::pause);
        }
        SystemThreadContext.shutdown(this.executor);
    }
}

