/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.context.session;

import com.acgist.snail.config.DownloadConfig;
import com.acgist.snail.utils.ThreadUtils;
import java.util.concurrent.atomic.AtomicLong;

public final class LimitSession {
    private final Type type;
    private final AtomicLong limitBuffer;
    private volatile long limitBufferTime;

    public LimitSession(Type type) {
        this.type = type;
        this.limitBuffer = new AtomicLong(0L);
        this.limitBufferTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void limit(long buffer) {
        long interval = System.currentTimeMillis() - this.limitBufferTime;
        long maxLimitBuffer = this.maxLimitBuffer();
        long limitBufferValue = this.limitBuffer.addAndGet(buffer);
        if (limitBufferValue >= maxLimitBuffer || interval >= 1000L) {
            AtomicLong atomicLong = this.limitBuffer;
            synchronized (atomicLong) {
                if (limitBufferValue == this.limitBuffer.get()) {
                    long expectTime = limitBufferValue * 1000L / maxLimitBuffer;
                    if (interval < expectTime) {
                        ThreadUtils.sleep(expectTime - interval);
                    }
                    this.limitBuffer.set(0L);
                    this.limitBufferTime = System.currentTimeMillis();
                } else {
                    this.limitBuffer.addAndGet(buffer);
                }
            }
        }
    }

    private long maxLimitBuffer() {
        if (this.type == Type.UPLOAD) {
            return DownloadConfig.getUploadBufferByte();
        }
        return DownloadConfig.getDownloadBufferByte();
    }

    public static enum Type {
        UPLOAD,
        DOWNLOAD;

    }
}

