/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.context.session;

import java.util.concurrent.atomic.AtomicInteger;

public final class SpeedSession {
    private static final byte SAMPLE_SIZE = 10;
    private long speed = 0L;
    private byte bufferSampleIndex = 0;
    private final AtomicInteger bufferSample = new AtomicInteger(0);
    private volatile long bufferSampleTime = System.currentTimeMillis();
    private final int[] bufferSamples = new int[10];
    private final long[] bufferSampleTimes = new long[10];

    public void buffer(int buffer) {
        this.bufferSample.addAndGet(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSpeed() {
        long time = System.currentTimeMillis();
        long interval = time - this.bufferSampleTime;
        if (interval >= 5000L) {
            SpeedSession speedSession = this;
            synchronized (speedSession) {
                if (time - this.bufferSampleTime == interval) {
                    this.bufferSampleTime = time;
                    this.speed = this.calculateSpeed(interval);
                }
            }
        }
        return this.speed;
    }

    private long calculateSpeed(long interval) {
        this.bufferSamples[this.bufferSampleIndex] = this.bufferSample.getAndSet(0);
        this.bufferSampleTimes[this.bufferSampleIndex] = interval;
        this.bufferSampleIndex = (byte)(this.bufferSampleIndex + 1);
        if (this.bufferSampleIndex >= 10) {
            this.bufferSampleIndex = 0;
        }
        long buffer = 0L;
        long bufferTime = 0L;
        for (int index = 0; index < 10; ++index) {
            buffer += (long)this.bufferSamples[index];
            bufferTime += this.bufferSampleTimes[index];
        }
        if (bufferTime <= 0L) {
            return 0L;
        }
        return buffer * 1000L / bufferTime;
    }

    public void reset() {
        for (int index = 0; index < 10; ++index) {
            this.bufferSamples[index] = 0;
            this.bufferSampleTimes[index] = 0L;
        }
    }
}

