/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.context.session;

import com.acgist.snail.context.IStatisticsSession;
import com.acgist.snail.context.session.LimitSession;
import com.acgist.snail.context.session.SpeedSession;
import java.util.concurrent.atomic.AtomicLong;

public final class StatisticsSession
implements IStatisticsSession {
    private final boolean limit;
    private final boolean speed;
    private final IStatisticsSession parent;
    private final AtomicLong uploadSize;
    private final AtomicLong downloadSize;
    private final LimitSession uploadLimit;
    private final LimitSession downloadLimit;
    private final SpeedSession uploadSpeed;
    private final SpeedSession downloadSpeed;

    public StatisticsSession() {
        this(false, true, null);
    }

    public StatisticsSession(boolean limit, IStatisticsSession parent) {
        this(limit, true, parent);
    }

    public StatisticsSession(boolean limit, boolean speed, IStatisticsSession parent) {
        this.limit = limit;
        this.speed = speed;
        this.parent = parent;
        this.uploadSize = new AtomicLong(0L);
        this.downloadSize = new AtomicLong(0L);
        if (limit) {
            this.uploadLimit = new LimitSession(LimitSession.Type.UPLOAD);
            this.downloadLimit = new LimitSession(LimitSession.Type.DOWNLOAD);
        } else {
            this.uploadLimit = null;
            this.downloadLimit = null;
        }
        if (speed) {
            this.uploadSpeed = new SpeedSession();
            this.downloadSpeed = new SpeedSession();
        } else {
            this.uploadSpeed = null;
            this.downloadSpeed = null;
        }
    }

    @Override
    public IStatisticsSession getStatistics() {
        return this;
    }

    @Override
    public void upload(int buffer) {
        if (this.parent != null) {
            this.parent.upload(buffer);
        }
        this.uploadSize.addAndGet(buffer);
    }

    @Override
    public void download(int buffer) {
        if (this.parent != null) {
            this.parent.download(buffer);
        }
        this.downloadSize.addAndGet(buffer);
    }

    @Override
    public void uploadLimit(int buffer) {
        if (this.parent != null) {
            this.parent.uploadLimit(buffer);
        }
        if (this.limit) {
            this.uploadLimit.limit(buffer);
        }
        if (this.speed) {
            this.uploadSpeed.buffer(buffer);
        }
    }

    @Override
    public void downloadLimit(int buffer) {
        if (this.parent != null) {
            this.parent.downloadLimit(buffer);
        }
        if (this.limit) {
            this.downloadLimit.limit(buffer);
        }
        if (this.speed) {
            this.downloadSpeed.buffer(buffer);
        }
    }

    @Override
    public long getUploadSpeed() {
        if (this.speed) {
            return this.uploadSpeed.getSpeed();
        }
        return 0L;
    }

    @Override
    public long getDownloadSpeed() {
        if (this.speed) {
            return this.downloadSpeed.getSpeed();
        }
        return 0L;
    }

    @Override
    public long getUploadSize() {
        return this.uploadSize.get();
    }

    @Override
    public void setUploadSize(long size) {
        this.uploadSize.set(size);
    }

    @Override
    public long getDownloadSize() {
        return this.downloadSize.get();
    }

    @Override
    public void setDownloadSize(long size) {
        this.downloadSize.set(size);
    }

    @Override
    public void reset() {
        this.resetUploadSpeed();
        this.resetDownloadSpeed();
    }

    @Override
    public void resetUploadSpeed() {
        if (this.speed) {
            this.uploadSpeed.reset();
        }
    }

    @Override
    public void resetDownloadSpeed() {
        if (this.speed) {
            this.downloadSpeed.reset();
        }
    }
}

