/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.context.session;

import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.context.EntityContext;
import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.context.ITaskSessionStatus;
import com.acgist.snail.context.StatisticsContext;
import com.acgist.snail.context.StatisticsGetter;
import com.acgist.snail.context.TaskContext;
import com.acgist.snail.context.entity.TaskEntity;
import com.acgist.snail.context.session.StatisticsSession;
import com.acgist.snail.context.wrapper.DescriptionWrapper;
import com.acgist.snail.downloader.IDownloader;
import com.acgist.snail.gui.GuiContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.protocol.Protocol;
import com.acgist.snail.protocol.ProtocolContext;
import com.acgist.snail.utils.BeanUtils;
import com.acgist.snail.utils.DateUtils;
import com.acgist.snail.utils.FileUtils;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public final class TaskSession
extends StatisticsGetter
implements ITaskSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskSession.class);
    private static final String PATTERN = "yyyy-MM-dd HH:mm";
    private static final String TASK_STATUS_VALUE = "statusValue";
    private static final long DELETE_TIMEOUT = 2000L;
    private IDownloader downloader;
    private final TaskEntity entity;
    private final AtomicBoolean deleteLock;

    private TaskSession(TaskEntity entity) {
        super(new StatisticsSession(true, StatisticsContext.getInstance().getStatistics()));
        this.entity = entity;
        this.deleteLock = new AtomicBoolean(false);
    }

    public static final ITaskSession newInstance(TaskEntity entity) throws DownloadException {
        if (entity == null) {
            throw new DownloadException("\u65b0\u5efaTaskSession\u5931\u8d25\uff1a\u7f3a\u5c11\u4efb\u52a1\u5b9e\u4f53");
        }
        return new TaskSession(entity);
    }

    @Override
    public IDownloader getDownloader() {
        return this.downloader;
    }

    @Override
    public IDownloader buildDownloader() throws DownloadException {
        if (this.downloader != null) {
            return this.downloader;
        }
        this.downloader = ProtocolContext.getInstance().buildDownloader(this);
        return this.downloader;
    }

    @Override
    public File getDownloadFile() {
        return new File(this.getFile());
    }

    @Override
    public File getDownloadFolder() {
        File file = this.getDownloadFile();
        if (file.isFile()) {
            return file.getParentFile();
        }
        return file;
    }

    @Override
    public List<String> multifileSelected() {
        return DescriptionWrapper.newDecoder(this.getDescription()).deserialize();
    }

    @Override
    public void setDownloadSize(long size) {
        this.statistics.setDownloadSize(size);
    }

    @Override
    public void updateDownloadSize() {
        this.setDownloadSize(FileUtils.fileSize(this.getFile()));
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> data = BeanUtils.toMap(this.entity).entrySet().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        data.put(TASK_STATUS_VALUE, this.getStatusValue());
        return data;
    }

    @Override
    public boolean statusAwait() {
        return this.getStatus() == ITaskSessionStatus.Status.AWAIT;
    }

    @Override
    public boolean statusDownload() {
        return this.getStatus() == ITaskSessionStatus.Status.DOWNLOAD;
    }

    @Override
    public boolean statusPause() {
        return this.getStatus() == ITaskSessionStatus.Status.PAUSE;
    }

    @Override
    public boolean statusCompleted() {
        return this.getStatus() == ITaskSessionStatus.Status.COMPLETED;
    }

    @Override
    public boolean statusFail() {
        return this.getStatus() == ITaskSessionStatus.Status.FAIL;
    }

    @Override
    public boolean statusDelete() {
        return this.getStatus() == ITaskSessionStatus.Status.DELETE;
    }

    @Override
    public boolean statusRunning() {
        return this.statusAwait() || this.statusDownload();
    }

    @Override
    public String getNameValue() {
        return this.getName();
    }

    @Override
    public String getStatusValue() {
        if (this.statusDownload()) {
            return FileUtils.formatSpeed(this.statistics.getDownloadSpeed());
        }
        return this.getStatus().getValue();
    }

    @Override
    public String getProgressValue() {
        if (this.statusCompleted()) {
            return FileUtils.formatSize(this.getSize());
        }
        return SymbolConfig.Symbol.SLASH.join(FileUtils.formatSize(this.getDownloadSize()), FileUtils.formatSize(this.getSize()));
    }

    @Override
    public String getCreateDateValue() {
        if (this.entity.getCreateDate() == null) {
            return SymbolConfig.Symbol.MINUS.toString();
        }
        return DateUtils.dateFormat(this.entity.getCreateDate(), PATTERN);
    }

    @Override
    public String getCompletedDateValue() {
        if (this.getCompletedDate() == null) {
            if (this.statusDownload()) {
                long downloadSpeed = this.statistics.getDownloadSpeed();
                if (downloadSpeed <= 0L) {
                    return SymbolConfig.Symbol.MINUS.toString();
                }
                long second = (this.getSize() - this.getDownloadSize()) / downloadSpeed;
                if (second <= 0L) {
                    second = 0L;
                }
                return DateUtils.format(second);
            }
            return SymbolConfig.Symbol.MINUS.toString();
        }
        return DateUtils.dateFormat(this.getCompletedDate(), PATTERN);
    }

    @Override
    public void reset() {
        if (this.statusDownload()) {
            this.setStatus(ITaskSessionStatus.Status.AWAIT);
        }
    }

    @Override
    public void await() {
        if (this.statusDownload()) {
            this.setStatus(ITaskSessionStatus.Status.AWAIT);
            this.unlockDownload();
        }
    }

    @Override
    public void start() throws DownloadException {
        if (this.statusDownload()) {
            return;
        }
        if (this.statusCompleted()) {
            return;
        }
        TaskContext.getInstance().submit(this);
        this.updateStatus(ITaskSessionStatus.Status.AWAIT);
    }

    @Override
    public void restart() throws DownloadException {
        this.pause();
        this.downloader = null;
        if (this.statusCompleted()) {
            this.setStatus(ITaskSessionStatus.Status.AWAIT);
            this.setCompletedDate(null);
        }
        this.start();
    }

    @Override
    public void pause() {
        if (this.statusPause()) {
            return;
        }
        if (this.statusCompleted()) {
            return;
        }
        this.updateStatus(ITaskSessionStatus.Status.PAUSE);
    }

    @Override
    public void repause() {
        if (this.statusCompleted()) {
            this.setStatus(ITaskSessionStatus.Status.PAUSE);
            this.setCompletedDate(null);
            this.update();
        }
    }

    @Override
    public void delete() {
        if (this.statusDelete()) {
            return;
        }
        if (this.statusDownload()) {
            this.deleteLock.set(true);
            this.updateStatus(ITaskSessionStatus.Status.DELETE);
            this.lockDelete();
        }
        if (this.downloader != null) {
            this.downloader.delete();
            this.downloader = null;
        }
        TaskContext.getInstance().remove(this);
        EntityContext.getInstance().deleteTask(this.entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockDelete() {
        if (this.deleteLock.get()) {
            AtomicBoolean atomicBoolean = this.deleteLock;
            synchronized (atomicBoolean) {
                if (this.deleteLock.get()) {
                    try {
                        this.deleteLock.wait(2000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOGGER.debug("\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockDelete() {
        AtomicBoolean atomicBoolean = this.deleteLock;
        synchronized (atomicBoolean) {
            this.deleteLock.set(false);
            this.deleteLock.notifyAll();
        }
    }

    @Override
    public void refresh() throws DownloadException {
        if (this.downloader != null) {
            this.downloader.refresh();
        }
    }

    @Override
    public boolean verify() {
        if (!this.statusCompleted()) {
            return false;
        }
        if (this.downloader == null) {
            return this.getDownloadFile().exists();
        }
        try {
            return this.downloader.verify();
        }
        catch (DownloadException e) {
            LOGGER.error("\u6821\u9a8c\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", e);
            return false;
        }
    }

    @Override
    public void unlockDownload() {
        if (this.downloader != null) {
            this.downloader.unlockDownload();
        }
    }

    @Override
    public void update() {
        EntityContext.getInstance().update(this.entity);
    }

    @Override
    public void updateStatus(ITaskSessionStatus.Status status) {
        if (this.statusCompleted()) {
            return;
        }
        if (status == ITaskSessionStatus.Status.COMPLETED) {
            this.setCompletedDate(new Date());
        }
        this.setStatus(status);
        this.update();
        this.unlockDownload();
        TaskContext.getInstance().refresh();
    }

    @Override
    public void magnetToTorrent() {
        if (this.getType() == Protocol.Type.MAGNET) {
            this.setType(Protocol.Type.TORRENT);
            this.setDownloadSize(0L);
        }
    }

    @Override
    public String getId() {
        return this.entity.getId();
    }

    @Override
    public void setId(String id) {
        this.entity.setId(id);
    }

    @Override
    public String getName() {
        return this.entity.getName();
    }

    @Override
    public void setName(String name) {
        this.entity.setName(name);
    }

    @Override
    public Protocol.Type getType() {
        return this.entity.getType();
    }

    @Override
    public void setType(Protocol.Type type) {
        this.entity.setType(type);
    }

    @Override
    public ITaskSession.FileType getFileType() {
        return this.entity.getFileType();
    }

    @Override
    public void setFileType(ITaskSession.FileType fileType) {
        this.entity.setFileType(fileType);
    }

    @Override
    public String getFile() {
        return this.entity.getFile();
    }

    @Override
    public void setFile(String file) {
        this.entity.setFile(file);
    }

    @Override
    public String getUrl() {
        return this.entity.getUrl();
    }

    @Override
    public void setUrl(String url) {
        this.entity.setUrl(url);
    }

    @Override
    public String getTorrent() {
        return this.entity.getTorrent();
    }

    @Override
    public void setTorrent(String torrent) {
        this.entity.setTorrent(torrent);
    }

    @Override
    public ITaskSessionStatus.Status getStatus() {
        return this.entity.getStatus();
    }

    @Override
    public void setStatus(ITaskSessionStatus.Status status) {
        this.entity.setStatus(status);
        GuiContext.getInstance().refreshTaskStatus(new Object[]{this.getId(), this.getStatus()});
    }

    @Override
    public Long getSize() {
        return this.entity.getSize();
    }

    @Override
    public void setSize(Long size) {
        this.entity.setSize(size);
    }

    @Override
    public Date getCompletedDate() {
        return this.entity.getCompletedDate();
    }

    @Override
    public void setCompletedDate(Date completedDate) {
        this.entity.setCompletedDate(completedDate);
    }

    @Override
    public String getDescription() {
        return this.entity.getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.entity.setDescription(description);
    }

    @Override
    public byte[] getPayload() {
        return this.entity.getPayload();
    }

    @Override
    public void setPayload(byte[] payload) {
        this.entity.setPayload(payload);
    }

    public String toString() {
        return BeanUtils.toString(this, this.getId(), this.getName());
    }
}

