/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.context.wrapper;

import com.acgist.snail.format.BEncodeDecoder;
import com.acgist.snail.format.BEncodeEncoder;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.PacketSizeException;
import com.acgist.snail.utils.CollectionUtils;
import com.acgist.snail.utils.StringUtils;
import java.util.List;
import java.util.Objects;

public final class DescriptionWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DescriptionWrapper.class);
    private final BEncodeEncoder encoder;
    private final BEncodeDecoder decoder;

    private DescriptionWrapper(BEncodeEncoder encoder, BEncodeDecoder decoder) {
        this.encoder = encoder;
        this.decoder = decoder;
    }

    public static final DescriptionWrapper newEncoder(List<String> list) {
        BEncodeEncoder encoder = CollectionUtils.isNotEmpty(list) ? BEncodeEncoder.newInstance().newList().put(list) : null;
        return new DescriptionWrapper(encoder, null);
    }

    public static final DescriptionWrapper newDecoder(String value) {
        BEncodeDecoder decoder = StringUtils.isNotEmpty(value) ? BEncodeDecoder.newInstance(value) : null;
        return new DescriptionWrapper(null, decoder);
    }

    public String serialize() {
        if (this.encoder == null) {
            return null;
        }
        return this.encoder.flush().toString();
    }

    public List<String> deserialize() {
        if (this.decoder == null) {
            return List.of();
        }
        try {
            return this.decoder.nextList().stream().filter(Objects::nonNull).map(StringUtils::getString).toList();
        }
        catch (PacketSizeException e) {
            LOGGER.error("\u89e3\u6790\u9009\u62e9\u6587\u4ef6\u5f02\u5e38", e);
            return List.of();
        }
    }
}

