/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.context.wrapper;

import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.utils.ArrayUtils;
import com.acgist.snail.utils.CollectionUtils;
import com.acgist.snail.utils.MapUtils;
import com.acgist.snail.utils.StringUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HeaderWrapper {
    private static final String DEFAULT_HEADER_SEPARATOR = SymbolConfig.Symbol.COLON.toString();
    private static final String DEFAULT_HEADER_PADDING = SymbolConfig.Symbol.SPACE.toString();
    private static final String HEADER_LINE_READER = SymbolConfig.Symbol.LINE_SEPARATOR.toString();
    private static final String HEADER_LINE_WRITER = SymbolConfig.LINE_SEPARATOR_COMPAT;
    protected final String headerSeparator;
    protected final String headerPadding;
    protected final String protocol;
    protected final boolean hasProtocol;
    protected final Map<String, List<String>> headers;

    protected HeaderWrapper(String content) {
        this(DEFAULT_HEADER_SEPARATOR, DEFAULT_HEADER_PADDING, content);
    }

    protected HeaderWrapper(String headerSeparator, String headerPadding, String content) {
        this.headerSeparator = headerSeparator;
        this.headerPadding = headerPadding;
        this.headers = new LinkedHashMap<String, List<String>>();
        if (StringUtils.isEmpty(content)) {
            this.protocol = null;
            this.hasProtocol = false;
        } else {
            String[] lines = content.split(HEADER_LINE_READER);
            this.protocol = this.buildProtocol(lines);
            this.hasProtocol = StringUtils.isNotEmpty(this.protocol);
            this.buildHeaders(lines);
        }
    }

    protected HeaderWrapper(Map<String, List<String>> headers) {
        this(DEFAULT_HEADER_SEPARATOR, DEFAULT_HEADER_PADDING, null, headers);
    }

    protected HeaderWrapper(String protocol, Map<String, List<String>> headers) {
        this(DEFAULT_HEADER_SEPARATOR, DEFAULT_HEADER_PADDING, protocol, headers);
    }

    protected HeaderWrapper(String headerSeparator, String headerPadding, String protocol, Map<String, List<String>> headers) {
        this.headerSeparator = headerSeparator;
        this.headerPadding = headerPadding;
        this.protocol = protocol;
        this.hasProtocol = StringUtils.isNotEmpty(this.protocol);
        this.headers = headers;
    }

    public static final HeaderWrapper newInstance(String content) {
        return new HeaderWrapper(content);
    }

    public static final HeaderWrapper newInstance(String headerSeparator, String headerPadding, String content) {
        return new HeaderWrapper(headerSeparator, headerPadding, content);
    }

    public static final HeaderWrapper newBuilder(String protocol) {
        return new HeaderWrapper(protocol, new LinkedHashMap<String, List<String>>());
    }

    public static final HeaderWrapper newBuilder(String protocol, Map<String, List<String>> headers) {
        return new HeaderWrapper(protocol, headers);
    }

    public static final HeaderWrapper newBuilder(String headerSeparator, String headerPadding, String protocol) {
        return new HeaderWrapper(headerSeparator, headerPadding, protocol, new LinkedHashMap<String, List<String>>());
    }

    public static final HeaderWrapper newBuilder(String headerSeparator, String headerPadding, String protocol, Map<String, List<String>> headers) {
        return new HeaderWrapper(headerSeparator, headerPadding, protocol, headers);
    }

    private String buildProtocol(String[] lines) {
        if (ArrayUtils.isEmpty(lines)) {
            return null;
        }
        String firstLine = lines[0];
        if (firstLine == null || firstLine.indexOf(this.headerSeparator) >= 0) {
            return null;
        }
        return firstLine.strip();
    }

    private void buildHeaders(String[] lines) {
        int jndex;
        if (ArrayUtils.isEmpty(lines)) {
            return;
        }
        int n = jndex = this.hasProtocol ? 1 : 0;
        while (jndex < lines.length) {
            String line = lines[jndex];
            if (!StringUtils.isEmpty(line)) {
                String value;
                String key;
                int index = line.indexOf(this.headerSeparator);
                if (index < 0) {
                    key = line.strip();
                    value = "";
                } else {
                    key = line.substring(0, index).strip();
                    value = line.substring(index + 1).strip();
                }
                this.setHeader(key, value);
            }
            ++jndex;
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHeader(String key) {
        List<String> list = this.getHeaderList(key);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        String value = list.get(0);
        return value == null ? value : value.strip();
    }

    public List<String> getHeaderList(String key) {
        if (this.isEmpty()) {
            return List.of();
        }
        return this.headers.entrySet().stream().filter(entry -> StringUtils.equalsIgnoreCase(key, (String)entry.getKey())).map(Map.Entry::getValue).filter(Objects::nonNull).findFirst().orElse(List.of());
    }

    public HeaderWrapper setHeader(String key, String value) {
        Objects.requireNonNull(this.headers, "\u5934\u90e8\u4fe1\u606f\u672a\u521d\u59cb\u5316");
        this.headers.computeIfAbsent(key, newKey -> new ArrayList()).add(value);
        return this;
    }

    public HeaderWrapper setHeader(String key, List<String> value) {
        Objects.requireNonNull(this.headers, "\u5934\u90e8\u4fe1\u606f\u672a\u521d\u59cb\u5316");
        this.headers.put(key, value);
        return this;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String build() {
        StringBuilder builder = new StringBuilder();
        if (this.hasProtocol) {
            builder.append(this.protocol).append(HEADER_LINE_WRITER);
        }
        if (this.isEmpty()) {
            return builder.toString();
        }
        this.headers.forEach((key, list) -> {
            if (CollectionUtils.isEmpty(list)) {
                this.buildLine(builder, (String)key, null);
            } else {
                list.stream().forEach(value -> this.buildLine(builder, (String)key, (String)value));
            }
        });
        return builder.toString();
    }

    protected void buildLine(StringBuilder builder, String key, String value) {
        builder.append(key).append(this.headerSeparator).append(this.headerPadding).append(value == null ? "" : value.strip()).append(HEADER_LINE_WRITER);
    }

    public boolean isEmpty() {
        return MapUtils.isEmpty(this.headers);
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public String toString() {
        return this.build();
    }
}

