/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.context.wrapper;

import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.context.wrapper.HeaderWrapper;
import com.acgist.snail.utils.StringUtils;
import com.acgist.snail.utils.UrlUtils;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import java.util.Map;

public final class HttpHeaderWrapper
extends HeaderWrapper {
    public static final String HEADER_RANGE = "Range";
    public static final String HEADER_USER_AGENT = "User-Agent";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_ACCEPT_RANGES = "Accept-Ranges";
    public static final String HEADER_CONTENT_RANGE = "Content-Range";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String HEADER_VALUE_BYTES = "bytes";
    public static final String HEADER_VALUE_FILENAME = "filename";

    private HttpHeaderWrapper(Map<String, List<String>> headers) {
        super(headers);
    }

    public static final HttpHeaderWrapper newInstance(Map<String, List<String>> headers) {
        return new HttpHeaderWrapper(headers);
    }

    public String getFileName(String defaultName) {
        String fileName = this.getHeader(HEADER_CONTENT_DISPOSITION);
        if (StringUtils.isEmpty(fileName)) {
            return defaultName;
        }
        int index = fileName.toLowerCase().indexOf(HEADER_VALUE_FILENAME);
        if (index >= 0) {
            fileName = this.extractFileName(index, fileName);
            if (StringUtils.isEmpty(fileName = this.charsetFileName(fileName))) {
                return defaultName;
            }
            return fileName;
        }
        return defaultName;
    }

    private String extractFileName(int index, String fileName) {
        String doubleQuote;
        String singleQuote;
        fileName = fileName.substring(index + HEADER_VALUE_FILENAME.length());
        index = (fileName = UrlUtils.decode(fileName)).indexOf(SymbolConfig.Symbol.EQUALS.toChar());
        if (index >= 0) {
            fileName = fileName.substring(index + 1);
        }
        if ((index = fileName.indexOf(SymbolConfig.Symbol.SEMICOLON.toChar())) >= 0) {
            fileName = fileName.substring(0, index);
        }
        if ((fileName = fileName.strip()).startsWith(singleQuote = SymbolConfig.Symbol.SINGLE_QUOTE.toString()) && fileName.endsWith(singleQuote)) {
            fileName = fileName.substring(1, fileName.length() - 1);
        }
        if (fileName.startsWith(doubleQuote = SymbolConfig.Symbol.DOUBLE_QUOTE.toString()) && fileName.endsWith(doubleQuote)) {
            fileName = fileName.substring(1, fileName.length() - 1);
        }
        if ((index = fileName.indexOf(SymbolConfig.Symbol.QUESTION.toChar())) >= 0) {
            fileName = fileName.substring(0, index);
        }
        return fileName.strip();
    }

    private String charsetFileName(String fileName) {
        if (StringUtils.isEmpty(fileName)) {
            return fileName;
        }
        CharsetEncoder gbkEncoder = Charset.forName("GBK").newEncoder();
        if (gbkEncoder.canEncode(fileName)) {
            return fileName;
        }
        char[] chars = fileName.toCharArray();
        for (int index = 0; index < chars.length; ++index) {
            chars[index] = (char)(chars[index] & 0xFF);
        }
        fileName = new String(chars);
        String fileNameUtf8 = StringUtils.charsetFrom(fileName, "ISO-8859-1");
        if (gbkEncoder.canEncode(fileNameUtf8)) {
            return fileNameUtf8;
        }
        String fileNameGbk = StringUtils.charset(fileName, "ISO-8859-1", "GBK");
        if (gbkEncoder.canEncode(fileNameGbk)) {
            return fileNameGbk;
        }
        return fileName;
    }

    public long fileSize() {
        long size = 0L;
        String value = this.getHeader(HEADER_CONTENT_LENGTH);
        if (StringUtils.isNumeric(value)) {
            size = Long.parseLong(value);
        }
        return size;
    }

    public boolean range() {
        if (HEADER_VALUE_BYTES.equalsIgnoreCase(this.getHeader(HEADER_ACCEPT_RANGES))) {
            return true;
        }
        return this.getHeader(HEADER_CONTENT_RANGE) != null;
    }
}

