/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.context.wrapper;

import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class KeyValueWrapper {
    private static final char DEFAULT_SEPARATOR = SymbolConfig.Symbol.AND.toChar();
    private static final char DEFAULT_CONNECTOR = SymbolConfig.Symbol.EQUALS.toChar();
    private final char separator;
    private final char connector;
    private final String content;
    private final Map<String, String> data;

    private KeyValueWrapper(char separator, char connector, String content, Map<String, String> data) {
        this.separator = separator;
        this.connector = connector;
        this.content = content;
        this.data = data == null ? new HashMap<String, String>() : data;
    }

    public static final KeyValueWrapper newInstance() {
        return new KeyValueWrapper(DEFAULT_SEPARATOR, DEFAULT_CONNECTOR, null, null);
    }

    public static final KeyValueWrapper newInstance(String content) {
        return new KeyValueWrapper(DEFAULT_SEPARATOR, DEFAULT_CONNECTOR, content, null);
    }

    public static final KeyValueWrapper newInstance(Map<String, String> data) {
        return new KeyValueWrapper(DEFAULT_SEPARATOR, DEFAULT_CONNECTOR, null, data);
    }

    public static final KeyValueWrapper newInstance(char separator, char connector) {
        return new KeyValueWrapper(separator, connector, null, null);
    }

    public static final KeyValueWrapper newInstance(char separator, char connector, String content) {
        return new KeyValueWrapper(separator, connector, content, null);
    }

    public static final KeyValueWrapper newInstance(char separator, char connector, Map<String, String> data) {
        return new KeyValueWrapper(separator, connector, null, data);
    }

    public String encode() {
        StringBuilder builder = new StringBuilder();
        this.data.forEach((key, value) -> builder.append((String)key).append(this.connector).append((String)value).append(this.separator));
        int length = builder.length();
        if (length > 0) {
            builder.setLength(length - 1);
        }
        return builder.toString();
    }

    public KeyValueWrapper decode() {
        if (StringUtils.isEmpty(this.content)) {
            return this;
        }
        int left = 0;
        int pos = -1;
        int length = this.content.length();
        int separatorLength = Character.toString(this.separator).length();
        do {
            String value;
            String key;
            String keyValue;
            if ((keyValue = (pos = this.content.indexOf(this.separator, left = pos + separatorLength)) < 0 ? this.content.substring(left).strip() : this.content.substring(left, pos).strip()).isEmpty()) continue;
            int index = keyValue.indexOf(this.connector);
            if (index < 0) {
                key = keyValue.strip();
                value = "";
            } else {
                key = keyValue.substring(0, index).strip();
                value = keyValue.substring(index + 1).strip();
            }
            this.data.put(key, value);
        } while (0 <= pos && pos < length);
        return this;
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public String get(String key, String defaultValue) {
        return this.data.getOrDefault(key, defaultValue);
    }

    public String getIgnoreCase(String key) {
        return this.getIgnoreCase(key, null);
    }

    public String getIgnoreCase(String key, String defaultValue) {
        return this.data.entrySet().stream().filter(entry -> StringUtils.equalsIgnoreCase((String)entry.getKey(), key)).map(Map.Entry::getValue).filter(Objects::nonNull).findFirst().orElse(defaultValue);
    }

    public String toString() {
        return this.data == null ? null : this.data.toString();
    }
}

