/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.context.wrapper;

import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.utils.BeanUtils;
import com.acgist.snail.utils.StringUtils;
import java.net.URI;

public final class URIWrapper {
    private String uri;
    private URI nativeUri;
    private int defaultPort;
    private String defaultUser;
    private String defaultPassword;
    private int port;
    private String user;
    private String password;

    private URIWrapper(String uri) {
        this.uri = uri;
    }

    private URIWrapper(String uri, int defaultPort) {
        this.uri = uri;
        this.defaultPort = defaultPort;
    }

    private URIWrapper(String uri, int defaultPort, String defaultUser, String defaultPassword) {
        this.uri = uri;
        this.defaultPort = defaultPort;
        this.defaultUser = defaultUser;
        this.defaultPassword = defaultPassword;
    }

    public static final URIWrapper newInstance(String uri) {
        return new URIWrapper(uri);
    }

    public static final URIWrapper newInstance(String uri, int defaultPort) {
        return new URIWrapper(uri, defaultPort);
    }

    public static final URIWrapper newInstance(String uri, int defaultPort, String defaultUser, String defaultPassword) {
        return new URIWrapper(uri, defaultPort, defaultUser, defaultPassword);
    }

    public URIWrapper decode() {
        this.nativeUri = URI.create(this.uri);
        this.decodePort();
        this.decodeUserInfo();
        return this;
    }

    private void decodePort() {
        int port = this.nativeUri.getPort();
        this.port = port < 0 ? this.defaultPort : port;
    }

    private void decodeUserInfo() {
        String userInfo = this.nativeUri.getUserInfo();
        String[] userInfos = SymbolConfig.Symbol.COLON.split(userInfo);
        if (userInfos.length <= 0) {
            this.user = this.defaultUser;
            this.password = this.defaultPassword;
        } else if (userInfos.length == 1) {
            this.user = userInfos[0];
            this.password = this.defaultPassword;
        } else {
            this.user = userInfos[0];
            this.password = userInfos[1];
        }
    }

    public String getScheme() {
        return this.nativeUri.getScheme();
    }

    public String getAuthority() {
        return this.nativeUri.getAuthority();
    }

    public String getHost() {
        return this.nativeUri.getHost();
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String password() {
        return this.password;
    }

    public String getPath() {
        return this.nativeUri.getPath();
    }

    public String getQuery() {
        return this.nativeUri.getQuery();
    }

    public String[] getQuerys() {
        String query = this.getQuery();
        if (StringUtils.isNotEmpty(query)) {
            return SymbolConfig.Symbol.AND.split(query);
        }
        String schemeSpecificPart = this.getSchemeSpecificPart();
        if (StringUtils.isNotEmpty(schemeSpecificPart)) {
            int index = schemeSpecificPart.indexOf(SymbolConfig.Symbol.QUESTION.toChar());
            int queryIndex = index < 0 ? 0 : index + 1;
            return SymbolConfig.Symbol.AND.split(schemeSpecificPart.substring(queryIndex));
        }
        return new String[0];
    }

    public String getFragment() {
        return this.nativeUri.getFragment();
    }

    public String getSchemeSpecificPart() {
        return this.nativeUri.getSchemeSpecificPart();
    }

    public String toString() {
        return BeanUtils.toString(this, this.uri);
    }
}

