/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.downloader;

import com.acgist.snail.Snail;
import com.acgist.snail.context.IStatisticsSession;
import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.context.ITaskSessionStatus;
import com.acgist.snail.context.SystemContext;
import com.acgist.snail.downloader.IDownloader;
import com.acgist.snail.gui.GuiContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.utils.StringUtils;
import java.io.File;

public abstract class Downloader
implements IDownloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(Downloader.class);
    protected volatile boolean fail;
    protected volatile boolean completed;
    protected final ITaskSession taskSession;
    protected final IStatisticsSession statistics;

    protected Downloader(ITaskSession taskSession) {
        taskSession.updateDownloadSize();
        this.fail = false;
        this.completed = false;
        this.taskSession = taskSession;
        this.statistics = taskSession.getStatistics();
    }

    public static final boolean checkFinish(int length, long downloadSize, long fileSize) {
        return length < 0 || 0L < fileSize && fileSize <= downloadSize;
    }

    @Override
    public final String getId() {
        return this.taskSession.getId();
    }

    @Override
    public final String getName() {
        return this.taskSession.getName();
    }

    @Override
    public final ITaskSession getTaskSession() {
        return this.taskSession;
    }

    @Override
    public final boolean statusAwait() {
        return this.taskSession.statusAwait();
    }

    @Override
    public final boolean statusDownload() {
        return this.taskSession.statusDownload();
    }

    @Override
    public final boolean statusPause() {
        return this.taskSession.statusPause();
    }

    @Override
    public final boolean statusCompleted() {
        return this.taskSession.statusCompleted();
    }

    @Override
    public final boolean statusFail() {
        return this.taskSession.statusFail();
    }

    @Override
    public final boolean statusDelete() {
        return this.taskSession.statusDelete();
    }

    @Override
    public final boolean statusRunning() {
        return this.taskSession.statusRunning();
    }

    @Override
    public void refresh() throws DownloadException {
    }

    @Override
    public boolean verify() throws DownloadException {
        File downloadFile = this.taskSession.getDownloadFile();
        boolean verify = downloadFile.exists();
        if (!verify) {
            LOGGER.info("\u6587\u4ef6\u5df2\u88ab\u5220\u9664\u91cd\u7f6e\u5df2\u7ecf\u4e0b\u8f7d\u5927\u5c0f\uff1a{}", downloadFile);
            this.taskSession.setDownloadSize(0L);
        }
        return verify;
    }

    @Override
    public final void fail(String message) {
        this.taskSession.updateStatus(ITaskSessionStatus.Status.FAIL);
        this.fail = true;
        StringBuilder noticeMessage = new StringBuilder();
        noticeMessage.append(this.getName()).append("\u4e0b\u8f7d\u5931\u8d25\uff1a");
        if (StringUtils.isEmpty(message)) {
            noticeMessage.append("\u672a\u77e5\u9519\u8bef");
        } else {
            noticeMessage.append(message);
        }
        GuiContext.getInstance().notice("\u4e0b\u8f7d\u5931\u8d25", noticeMessage.toString(), GuiContext.MessageType.WARN);
    }

    @Override
    public void unlockDownload() {
    }

    @Override
    public void release() {
        SystemContext.gc();
        Snail.getInstance().unlockDownload();
    }

    @Override
    public void delete() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        String name = this.getName();
        if (this.statusAwait()) {
            ITaskSession iTaskSession = this.taskSession;
            synchronized (iTaskSession) {
                if (this.statusAwait()) {
                    LOGGER.debug("\u5f00\u59cb\u4e0b\u8f7d\u4efb\u52a1\uff1a{}", name);
                    this.fail = false;
                    this.completed = false;
                    this.taskSession.setStatus(ITaskSessionStatus.Status.DOWNLOAD);
                    try {
                        this.open();
                        this.download();
                    }
                    catch (Exception e) {
                        LOGGER.error("\u4efb\u52a1\u4e0b\u8f7d\u5f02\u5e38", e);
                        this.fail(e.getMessage());
                    }
                    this.checkCompletedAndMark();
                    this.release();
                    this.taskSession.unlockDelete();
                    LOGGER.debug("\u4efb\u52a1\u4e0b\u8f7d\u7ed3\u675f\uff1a{}", name);
                } else {
                    LOGGER.debug("\u4efb\u52a1\u72b6\u6001\u9519\u8bef\uff1a{} - {}", new Object[]{name, this.taskSession.getStatus()});
                }
            }
        }
        LOGGER.debug("\u4efb\u52a1\u72b6\u6001\u9519\u8bef\uff1a{} - {}", new Object[]{name, this.taskSession.getStatus()});
    }

    protected final boolean downloadable() {
        return !this.fail && !this.completed && this.statusDownload();
    }

    private final void checkCompletedAndMark() {
        if (this.completed) {
            this.taskSession.updateStatus(ITaskSessionStatus.Status.COMPLETED);
            GuiContext.getInstance().notice("\u4e0b\u8f7d\u5b8c\u6210", "\u4efb\u52a1\u4e0b\u8f7d\u5b8c\u6210\uff1a" + this.getName());
        }
    }
}

