/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.downloader;

import com.acgist.snail.config.DownloadConfig;
import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.downloader.Downloader;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.net.NetException;
import com.acgist.snail.utils.IoUtils;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public abstract class MonofileDownloader
extends Downloader {
    private static final long FAST_CHECK_TIME = 2000L;
    protected ReadableByteChannel input;
    protected WritableByteChannel output;
    private volatile long fastCheckTime;

    protected MonofileDownloader(ITaskSession taskSession) {
        super(taskSession);
    }

    @Override
    public void open() throws NetException, DownloadException {
        this.buildInput();
        this.buildOutput();
    }

    @Override
    public void download() throws DownloadException {
        int length = 0;
        long fileSize = this.taskSession.getSize();
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        try {
            while (this.downloadable()) {
                length = this.input.read(buffer);
                if (length >= 0) {
                    buffer.flip();
                    this.output.write(buffer);
                    buffer.compact();
                    this.statistics.download(length);
                    this.statistics.downloadLimit(length);
                    this.fastCheckTime = System.currentTimeMillis();
                }
                if (!Downloader.checkFinish(length, this.taskSession.getDownloadSize(), fileSize)) continue;
                this.completed = true;
                break;
            }
        }
        catch (IOException e) {
            throw new DownloadException("\u6570\u636e\u6d41\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    @Override
    public void unlockDownload() {
        super.unlockDownload();
        if (System.currentTimeMillis() - this.fastCheckTime > 2000L) {
            IoUtils.close(this.input);
        }
    }

    protected void buildOutput() throws DownloadException {
        try {
            long size = this.taskSession.getDownloadSize();
            int bufferSize = DownloadConfig.getMemoryBufferByte(this.taskSession.getSize());
            FileOutputStream outputStream = size > 0L ? new FileOutputStream(this.taskSession.getFile(), true) : new FileOutputStream(this.taskSession.getFile());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, bufferSize);
            this.output = Channels.newChannel(bufferedOutputStream);
        }
        catch (FileNotFoundException e) {
            throw new DownloadException("\u4e0b\u8f7d\u6587\u4ef6\u6253\u5f00\u5931\u8d25", e);
        }
    }

    protected abstract void buildInput() throws NetException, DownloadException;
}

