/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.downloader;

import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.downloader.Downloader;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.net.NetException;
import com.acgist.snail.utils.FileUtils;

public abstract class MultifileDownloader
extends Downloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifileDownloader.class);
    protected final Object downloadLock = new Object();

    protected MultifileDownloader(ITaskSession taskSession) {
        super(taskSession);
    }

    @Override
    public void open() throws NetException, DownloadException {
        FileUtils.buildFolder(this.taskSession.getFile());
        this.loadDownload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download() throws DownloadException {
        if (this.downloadable()) {
            Object object = this.downloadLock;
            synchronized (object) {
                while (this.downloadable()) {
                    try {
                        this.downloadLock.wait(Long.MAX_VALUE);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOGGER.debug("\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38", e);
                    }
                    this.completed = this.checkCompleted();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockDownload() {
        super.unlockDownload();
        Object object = this.downloadLock;
        synchronized (object) {
            this.downloadLock.notifyAll();
        }
    }

    protected abstract void loadDownload() throws DownloadException;

    protected abstract boolean checkCompleted();
}

