/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.downloader.ftp;

import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.downloader.MonofileDownloader;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.ftp.FtpClient;
import com.acgist.snail.utils.FileUtils;
import com.acgist.snail.utils.IoUtils;
import java.nio.channels.Channels;

public final class FtpDownloader
extends MonofileDownloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FtpDownloader.class);
    private FtpClient client;

    private FtpDownloader(ITaskSession taskSession) {
        super(taskSession);
    }

    public static final FtpDownloader newInstance(ITaskSession taskSession) {
        return new FtpDownloader(taskSession);
    }

    @Override
    public void release() {
        if (this.client != null) {
            this.client.close();
        }
        IoUtils.close(this.input);
        IoUtils.close(this.output);
        super.release();
    }

    @Override
    protected void buildInput() throws NetException {
        this.client = FtpClient.newInstance(this.taskSession.getUrl());
        if (this.client.connect()) {
            long downloadSize = FileUtils.fileSize(this.taskSession.getFile());
            this.input = Channels.newChannel(this.client.download(downloadSize));
            if (this.client.range()) {
                LOGGER.debug("FTP\u65ad\u70b9\u4e0b\u8f7d\uff1a{}", downloadSize);
                this.taskSession.setDownloadSize(downloadSize);
            } else {
                LOGGER.debug("FTP\u91cd\u65b0\u4e0b\u8f7d\uff1a{}", downloadSize);
                this.taskSession.setDownloadSize(0L);
            }
        } else {
            this.fail("FTP\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25");
        }
    }
}

