/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.downloader.hls;

import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.downloader.MultifileDownloader;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.hls.HlsContext;
import com.acgist.snail.net.hls.HlsSession;
import com.acgist.snail.net.hls.TsLinker;

public final class HlsDownloader
extends MultifileDownloader {
    private HlsSession hlsSession;

    protected HlsDownloader(ITaskSession taskSession) {
        super(taskSession);
    }

    public static final HlsDownloader newInstance(ITaskSession taskSession) {
        return new HlsDownloader(taskSession);
    }

    @Override
    public void open() throws NetException, DownloadException {
        this.hlsSession = this.loadHlsSession();
        super.open();
    }

    @Override
    public void release() {
        if (this.hlsSession != null) {
            this.hlsSession.release();
            if (this.completed) {
                this.tsLink();
                this.delete();
            }
        }
        super.release();
    }

    @Override
    public void delete() {
        super.delete();
        if (this.hlsSession != null) {
            this.hlsSession.delete();
        }
    }

    @Override
    protected void loadDownload() throws DownloadException {
        this.completed = this.hlsSession.download();
    }

    @Override
    protected boolean checkCompleted() {
        return this.hlsSession.checkCompleted();
    }

    private HlsSession loadHlsSession() {
        return HlsContext.getInstance().hlsSession(this.taskSession);
    }

    private void tsLink() {
        TsLinker linker = TsLinker.newInstance(this.taskSession.getName(), this.taskSession.getFile(), this.hlsSession.cipher(), this.taskSession.multifileSelected());
        long size = linker.link();
        if (size >= 0L && size != this.taskSession.getSize()) {
            this.taskSession.setSize(size);
            this.taskSession.update();
        }
    }
}

