/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.downloader.http;

import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.context.wrapper.HttpHeaderWrapper;
import com.acgist.snail.downloader.MonofileDownloader;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.http.HttpClient;
import com.acgist.snail.utils.FileUtils;
import com.acgist.snail.utils.IoUtils;
import java.nio.channels.Channels;

public final class HttpDownloader
extends MonofileDownloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpDownloader.class);

    private HttpDownloader(ITaskSession taskSession) {
        super(taskSession);
    }

    public static final HttpDownloader newInstance(ITaskSession taskSession) {
        return new HttpDownloader(taskSession);
    }

    @Override
    public void release() {
        IoUtils.close(this.input);
        IoUtils.close(this.output);
        super.release();
    }

    @Override
    protected void buildInput() throws NetException {
        long downloadSize = FileUtils.fileSize(this.taskSession.getFile());
        HttpClient client = HttpClient.newDownloader(this.taskSession.getUrl()).range(downloadSize).get();
        if (client.downloadable()) {
            HttpHeaderWrapper headers = client.responseHeader();
            this.input = Channels.newChannel(client.response());
            if (headers.range()) {
                LOGGER.debug("HTTP\u65ad\u70b9\u4e0b\u8f7d\uff1a{}", downloadSize);
                this.taskSession.setDownloadSize(downloadSize);
            } else {
                LOGGER.debug("HTTP\u91cd\u65b0\u4e0b\u8f7d\uff1a{}", downloadSize);
                this.taskSession.setDownloadSize(0L);
            }
        } else if (this.taskSession.getDownloadSize() == this.taskSession.getSize().longValue()) {
            this.completed = true;
        } else {
            this.fail("HTTP\u8bf7\u6c42\u5931\u8d25\uff1a" + client.getCode());
        }
    }
}

