/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.downloader.torrent;

import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.downloader.TorrentSessionDownloader;
import com.acgist.snail.gui.GuiContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.net.torrent.TorrentSession;

public final class TorrentDownloader
extends TorrentSessionDownloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TorrentDownloader.class);

    private TorrentDownloader(ITaskSession taskSession) {
        super(taskSession);
    }

    public static final TorrentDownloader newInstance(ITaskSession taskSession) {
        return new TorrentDownloader(taskSession);
    }

    @Override
    public void refresh() throws DownloadException {
        super.refresh();
        boolean unchange = true;
        if (this.torrentSession != null) {
            unchange = this.torrentSession.reload() <= 0;
        } else if (this.statusCompleted()) {
            unchange = false;
            this.torrentSession = this.loadTorrentSession();
        }
        if (this.statusCompleted()) {
            if (unchange) {
                GuiContext.getInstance().alert("\u4e0b\u8f7d\u6210\u529f", "\u4efb\u52a1\u5df2\u7ecf\u5b8c\u6210\u4e0b\u8f7d");
            } else if (this.torrentSession.verify()) {
                GuiContext.getInstance().alert("\u4e0b\u8f7d\u6210\u529f", "\u4efb\u52a1\u5df2\u7ecf\u5b8c\u6210\u4e0b\u8f7d");
            } else {
                this.taskSession.repause();
                GuiContext.getInstance().alert("\u4fee\u6539\u6210\u529f", "\u91cd\u65b0\u5f00\u59cb\u4e0b\u8f7d\u4efb\u52a1");
            }
        } else if (this.torrentSession != null) {
            this.torrentSession.checkCompletedAndUnlock();
        }
    }

    @Override
    public boolean verify() throws DownloadException {
        boolean verify = super.verify();
        if (verify) {
            if (this.torrentSession == null) {
                this.torrentSession = this.loadTorrentSession();
            }
            if (verify = this.torrentSession.verify()) {
                LOGGER.debug("BT\u4efb\u52a1\u6587\u4ef6\u6821\u9a8c\u6210\u529f", new Object[0]);
            } else {
                LOGGER.debug("BT\u4efb\u52a1\u6587\u4ef6\u6821\u9a8c\u5931\u8d25\uff1a\u66f4\u65b0\u4f4d\u56fe", new Object[0]);
                this.torrentSession.updatePieces(true);
            }
        }
        return verify;
    }

    @Override
    public void release() {
        if (this.torrentSession != null) {
            this.torrentSession.releaseDownload();
            this.torrentSession.updatePieces(true);
        }
        super.release();
    }

    @Override
    public void delete() {
        super.delete();
        if (this.torrentSession != null) {
            this.torrentSession.releaseUpload();
            this.torrentSession.delete();
        }
    }

    @Override
    protected TorrentSession loadTorrentSession() throws DownloadException {
        TorrentSession torrentSession = super.loadTorrentSession();
        torrentSession.upload(this.taskSession);
        return torrentSession;
    }

    @Override
    protected void loadDownload() throws DownloadException {
        this.completed = this.torrentSession.download();
    }
}

