/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.format;

import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.PacketSizeException;
import com.acgist.snail.utils.ByteUtils;
import com.acgist.snail.utils.CollectionUtils;
import com.acgist.snail.utils.ListUtils;
import com.acgist.snail.utils.MapUtils;
import com.acgist.snail.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class BEncodeDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(BEncodeDecoder.class);
    private static final int MIN_CONTENT_LENGTH = 2;
    private Type type;
    private List<Object> list;
    private Map<String, Object> map;
    private final ByteArrayInputStream inputStream;

    private BEncodeDecoder(byte[] bytes) {
        Objects.requireNonNull(bytes, "B\u7f16\u7801\u5185\u5bb9\u9519\u8bef");
        if (bytes.length < 2) {
            throw new IllegalArgumentException("B\u7f16\u7801\u5185\u5bb9\u9519\u8bef");
        }
        this.inputStream = new ByteArrayInputStream(bytes);
    }

    public static final BEncodeDecoder newInstance(byte[] bytes) {
        Objects.requireNonNull(bytes, "B\u7f16\u7801\u5185\u5bb9\u9519\u8bef");
        return new BEncodeDecoder(bytes);
    }

    public static final BEncodeDecoder newInstance(String content) {
        Objects.requireNonNull(content, "B\u7f16\u7801\u5185\u5bb9\u9519\u8bef");
        return new BEncodeDecoder(content.getBytes());
    }

    public static final BEncodeDecoder newInstance(ByteBuffer buffer) {
        Objects.requireNonNull(buffer, "B\u7f16\u7801\u5185\u5bb9\u9519\u8bef");
        return new BEncodeDecoder(ByteUtils.remainingToBytes(buffer));
    }

    public boolean isEmpty() {
        if (this.type == null) {
            return true;
        }
        return switch (this.type) {
            case Type.MAP -> MapUtils.isEmpty(this.map);
            case Type.LIST -> CollectionUtils.isEmpty(this.list);
            default -> true;
        };
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public BEncodeDecoder next() throws PacketSizeException {
        this.nextType();
        return this;
    }

    public Type nextType() throws PacketSizeException {
        boolean none;
        boolean bl = none = this.inputStream == null || this.inputStream.available() <= 0;
        if (none) {
            this.type = Type.NONE;
            return this.type;
        }
        char charType = (char)this.inputStream.read();
        switch (charType) {
            case 'd': {
                this.map = BEncodeDecoder.readMap(this.inputStream);
                this.type = Type.MAP;
                break;
            }
            case 'l': {
                this.list = BEncodeDecoder.readList(this.inputStream);
                this.type = Type.LIST;
                break;
            }
            default: {
                LOGGER.warn("B\u7f16\u7801\u9519\u8bef\uff08\u672a\u77e5\u7c7b\u578b\uff09\uff1a{}", Character.valueOf(charType));
                this.type = Type.NONE;
            }
        }
        return this.type;
    }

    public List<Object> nextList() throws PacketSizeException {
        Type nextType = this.nextType();
        if (nextType == Type.LIST) {
            return this.list;
        }
        LOGGER.warn("B\u7f16\u7801\u89e3\u6790List\u7c7b\u578b\u9519\u8bef\uff1a{}", new Object[]{nextType});
        return List.of();
    }

    public Map<String, Object> nextMap() throws PacketSizeException {
        Type nextType = this.nextType();
        if (nextType == Type.MAP) {
            return this.map;
        }
        LOGGER.warn("B\u7f16\u7801\u89e3\u6790Map\u7c7b\u578b\u9519\u8bef\uff1a{}", new Object[]{nextType});
        return Map.of();
    }

    public byte[] oddBytes() {
        if (this.inputStream == null) {
            return new byte[0];
        }
        return this.inputStream.readAllBytes();
    }

    private static final Long readLong(ByteArrayInputStream inputStream) {
        int index;
        StringBuilder valueBuilder = new StringBuilder();
        while ((index = inputStream.read()) >= 0) {
            char indexChar = (char)index;
            if (indexChar == 'e') {
                String number = valueBuilder.toString();
                if (!StringUtils.isNumeric(number)) {
                    throw new IllegalArgumentException("B\u7f16\u7801\u9519\u8bef\uff08\u6570\u503c\uff09\uff1a" + number);
                }
                return Long.valueOf(number);
            }
            valueBuilder.append(indexChar);
        }
        return 0L;
    }

    private static final List<Object> readList(ByteArrayInputStream inputStream) throws PacketSizeException {
        int index;
        ArrayList<Object> list = new ArrayList<Object>();
        StringBuilder lengthBuilder = new StringBuilder();
        block8: while ((index = inputStream.read()) >= 0) {
            char indexChar = (char)index;
            switch (indexChar) {
                case 'e': {
                    return list;
                }
                case 'i': {
                    list.add(BEncodeDecoder.readLong(inputStream));
                    continue block8;
                }
                case 'l': {
                    list.add(BEncodeDecoder.readList(inputStream));
                    continue block8;
                }
                case 'd': {
                    list.add(BEncodeDecoder.readMap(inputStream));
                    continue block8;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    lengthBuilder.append(indexChar);
                    continue block8;
                }
                case ':': {
                    if (lengthBuilder.length() > 0) {
                        list.add(BEncodeDecoder.readBytes(lengthBuilder, inputStream));
                        continue block8;
                    }
                    LOGGER.warn("B\u7f16\u7801\u9519\u8bef\uff08\u957f\u5ea6\uff09\uff1a{}", lengthBuilder);
                    continue block8;
                }
            }
            LOGGER.warn("B\u7f16\u7801\u9519\u8bef\uff08\u672a\u77e5\u7c7b\u578b\uff09\uff1a{}", Character.valueOf(indexChar));
        }
        return list;
    }

    private static final Map<String, Object> readMap(ByteArrayInputStream inputStream) throws PacketSizeException {
        int index;
        String key = null;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        StringBuilder lengthBuilder = new StringBuilder();
        block8: while ((index = inputStream.read()) >= 0) {
            char indexChar = (char)index;
            switch (indexChar) {
                case 'e': {
                    return map;
                }
                case 'i': {
                    if (key != null) {
                        map.put(key, BEncodeDecoder.readLong(inputStream));
                        key = null;
                        continue block8;
                    }
                    LOGGER.warn("B\u7f16\u7801key\u4e3a\u7a7a\u8df3\u8fc7\uff08I\uff09", new Object[0]);
                    continue block8;
                }
                case 'l': {
                    if (key != null) {
                        map.put(key, BEncodeDecoder.readList(inputStream));
                        key = null;
                        continue block8;
                    }
                    LOGGER.warn("B\u7f16\u7801key\u4e3a\u7a7a\u8df3\u8fc7\uff08L\uff09", new Object[0]);
                    continue block8;
                }
                case 'd': {
                    if (key != null) {
                        map.put(key, BEncodeDecoder.readMap(inputStream));
                        key = null;
                        continue block8;
                    }
                    LOGGER.warn("B\u7f16\u7801key\u4e3a\u7a7a\u8df3\u8fc7\uff08D\uff09", new Object[0]);
                    continue block8;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    lengthBuilder.append(indexChar);
                    continue block8;
                }
                case ':': {
                    if (lengthBuilder.length() > 0) {
                        byte[] bytes = BEncodeDecoder.readBytes(lengthBuilder, inputStream);
                        if (key == null) {
                            key = new String(bytes);
                            continue block8;
                        }
                        map.put(key, bytes);
                        key = null;
                        continue block8;
                    }
                    LOGGER.warn("B\u7f16\u7801\u9519\u8bef\uff08\u957f\u5ea6\uff09\uff1a{}", lengthBuilder);
                    continue block8;
                }
            }
            LOGGER.warn("B\u7f16\u7801\u9519\u8bef\uff08\u672a\u77e5\u7c7b\u578b\uff09\uff1a{}", Character.valueOf(indexChar));
        }
        return map;
    }

    private static final byte[] readBytes(StringBuilder lengthBuilder, ByteArrayInputStream inputStream) throws PacketSizeException {
        String number = lengthBuilder.toString();
        if (!StringUtils.isNumeric(number)) {
            throw new IllegalArgumentException("B\u7f16\u7801\u9519\u8bef\uff08\u6570\u503c\uff09\uff1a" + number);
        }
        int length = Integer.parseInt(number);
        PacketSizeException.verify(length);
        lengthBuilder.setLength(0);
        byte[] bytes = new byte[length];
        try {
            int readLength = inputStream.read(bytes);
            if (readLength != length) {
                LOGGER.warn("B\u7f16\u7801\u9519\u8bef\uff08\u8bfb\u53d6\u957f\u5ea6\u548c\u5b9e\u9645\u957f\u5ea6\u4e0d\u7b26\uff09\uff1a{} - {}", length, readLength);
            }
        }
        catch (IOException e) {
            LOGGER.error("B\u7f16\u7801\u8bfb\u53d6\u5f02\u5e38", e);
        }
        return bytes;
    }

    public Object get(int index) {
        return ListUtils.get(this.list, index);
    }

    public Byte getByte(int index) {
        return ListUtils.getByte(this.list, index);
    }

    public Integer getInteger(int index) {
        return ListUtils.getInteger(this.list, index);
    }

    public Long getLong(int index) {
        return ListUtils.getLong(this.list, index);
    }

    public String getString(int index) {
        return ListUtils.getString(this.list, index);
    }

    public String getString(int index, String encoding) {
        return ListUtils.getString(this.list, index, encoding);
    }

    public byte[] getBytes(int index) {
        return ListUtils.getBytes(this.list, index);
    }

    public List<Object> getList(int index) {
        return ListUtils.getList(this.list, index);
    }

    public Map<String, Object> getMap(int index) {
        return ListUtils.getMap(this.list, index);
    }

    public Object get(String key) {
        return MapUtils.get(this.map, key);
    }

    public Byte getByte(String key) {
        return MapUtils.getByte(this.map, key);
    }

    public Integer getInteger(String key) {
        return MapUtils.getInteger(this.map, key);
    }

    public Long getLong(String key) {
        return MapUtils.getLong(this.map, key);
    }

    public String getString(String key) {
        return MapUtils.getString(this.map, key);
    }

    public String getString(String key, String encoding) {
        return MapUtils.getString(this.map, key, encoding);
    }

    public byte[] getBytes(String key) {
        return MapUtils.getBytes(this.map, key);
    }

    public List<Object> getList(String key) {
        return MapUtils.getList(this.map, key);
    }

    public Map<String, Object> getMap(String key) {
        return MapUtils.getMap(this.map, key);
    }

    public String toString() {
        return new String(this.oddBytes());
    }

    public static enum Type {
        MAP,
        LIST,
        NONE;

    }
}

