/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.format;

import com.acgist.snail.format.BEncodeDecoder;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class BEncodeEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(BEncodeEncoder.class);
    private List<Object> list;
    private Map<String, Object> map;
    private BEncodeDecoder.Type type;
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

    private BEncodeEncoder() {
    }

    public static final BEncodeEncoder newInstance() {
        return new BEncodeEncoder();
    }

    public BEncodeEncoder newList() {
        this.type = BEncodeDecoder.Type.LIST;
        this.list = new ArrayList<Object>();
        return this;
    }

    public BEncodeEncoder newMap() {
        this.type = BEncodeDecoder.Type.MAP;
        this.map = new LinkedHashMap<String, Object>();
        return this;
    }

    public BEncodeEncoder put(Object value) {
        if (this.type == BEncodeDecoder.Type.LIST) {
            this.list.add(value);
        }
        return this;
    }

    public BEncodeEncoder put(List<?> list) {
        if (this.type == BEncodeDecoder.Type.LIST) {
            this.list.addAll(list);
        }
        return this;
    }

    public BEncodeEncoder put(String key, Object value) {
        if (this.type == BEncodeDecoder.Type.MAP) {
            this.map.put(key, value);
        }
        return this;
    }

    public BEncodeEncoder put(Map<String, ?> map) {
        if (this.type == BEncodeDecoder.Type.MAP) {
            this.map.putAll(map);
        }
        return this;
    }

    public BEncodeEncoder flush() {
        if (this.type == BEncodeDecoder.Type.MAP) {
            this.writeMap(this.map);
        } else if (this.type == BEncodeDecoder.Type.LIST) {
            this.writeList(this.list);
        } else {
            LOGGER.warn("B\u7f16\u7801\u9519\u8bef\uff08\u672a\u77e5\u7c7b\u578b\uff09\uff1a{}", new Object[]{this.type});
        }
        return this;
    }

    public BEncodeEncoder write(byte[] bytes) {
        try {
            if (bytes != null) {
                this.outputStream.write(bytes);
            }
        }
        catch (IOException e) {
            LOGGER.error("B\u7f16\u7801\u8f93\u51fa\u5f02\u5e38", e);
        }
        return this;
    }

    private void write(char value) {
        this.outputStream.write(value);
    }

    private BEncodeEncoder writeList(List<?> list) {
        if (list == null) {
            return this;
        }
        this.write('l');
        list.forEach(this::writeObject);
        this.write('e');
        return this;
    }

    private BEncodeEncoder writeMap(Map<?, ?> map) {
        if (map == null) {
            return this;
        }
        this.write('d');
        map.forEach((key, value) -> {
            this.writeObject(key);
            this.writeObject(value);
        });
        this.write('e');
        return this;
    }

    private void writeObject(Object value) {
        if (value instanceof String) {
            String string = (String)value;
            this.writeBytes(string.getBytes());
        } else if (value instanceof Number) {
            Number number = (Number)value;
            this.writeNumber(number);
        } else if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            this.writeBytes(bytes);
        } else if (value instanceof Map) {
            Map map = (Map)value;
            this.writeMap(map);
        } else if (value instanceof List) {
            List list = (List)value;
            this.writeList(list);
        } else if (value == null) {
            this.writeBytes(new byte[0]);
        } else {
            this.writeBytes(value.toString().getBytes());
        }
    }

    private void writeNumber(Number number) {
        this.write('i');
        this.write(number.toString().getBytes());
        this.write('e');
    }

    private void writeBytes(byte[] bytes) {
        this.write(String.valueOf(bytes.length).getBytes());
        this.write(':');
        this.write(bytes);
    }

    public byte[] bytes() {
        return this.outputStream.toByteArray();
    }

    public String toString() {
        return new String(this.bytes());
    }

    public static final byte[] encodeList(List<?> list) {
        return BEncodeEncoder.newInstance().writeList(list).bytes();
    }

    public static final String encodeListString(List<?> list) {
        return new String(BEncodeEncoder.encodeList(list));
    }

    public static final byte[] encodeMap(Map<?, ?> map) {
        return BEncodeEncoder.newInstance().writeMap(map).bytes();
    }

    public static final String encodeMapString(Map<?, ?> map) {
        return new String(BEncodeEncoder.encodeMap(map));
    }
}

