/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.format;

import com.acgist.snail.utils.ArrayUtils;
import com.acgist.snail.utils.StringUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public final class JSON {
    private static final char[] CHARS = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '\\'};
    private static final String[] CHARS_ESCAPE = new String[]{"\\u0000", "\\u0001", "\\u0002", "\\u0003", "\\u0004", "\\u0005", "\\u0006", "\\u0007", "\\b", "\\t", "\\n", "\\u000b", "\\f", "\\r", "\\u000e", "\\u000f", "\\u0010", "\\u0011", "\\u0012", "\\u0013", "\\u0014", "\\u0015", "\\u0016", "\\u0017", "\\u0018", "\\u0019", "\\u001a", "\\u001b", "\\u001c", "\\u001d", "\\u001e", "\\u001f", "\\\"", "\\\\"};
    private Type type;
    private List<Object> list;
    private Map<Object, Object> map;
    private static boolean lazy = true;

    private JSON() {
    }

    public static final JSON ofMap(Map<?, ?> map) {
        JSON json = new JSON();
        json.map = new LinkedHashMap(map);
        json.type = Type.MAP;
        return json;
    }

    public static final JSON ofList(List<?> list) {
        JSON json = new JSON();
        json.list = new ArrayList(list);
        json.type = Type.LIST;
        return json;
    }

    public static final JSON ofString(String content) {
        if (StringUtils.isEmpty(content)) {
            throw new IllegalArgumentException("JSON\u683c\u5f0f\u9519\u8bef\uff1a" + content);
        }
        if ((content = content.strip()).isEmpty()) {
            throw new IllegalArgumentException("JSON\u683c\u5f0f\u9519\u8bef\uff1a" + content);
        }
        JSON json = new JSON();
        char prefix = content.charAt(0);
        char suffix = content.charAt(content.length() - 1);
        if (prefix == '{' && suffix == '}') {
            json.type = Type.MAP;
        } else if (prefix == '[' && suffix == ']') {
            json.type = Type.LIST;
        } else {
            throw new IllegalArgumentException("JSON\u683c\u5f0f\u9519\u8bef\uff1a" + content);
        }
        content = content.substring(1, content.length() - 1);
        json.deserialize(content);
        return json;
    }

    public static final void lazy() {
        lazy = true;
    }

    public static final void eager() {
        lazy = false;
    }

    private String serialize() {
        StringBuilder builder = new StringBuilder();
        if (this.type == Type.MAP) {
            JSON.serializeMap(this.map, builder);
        } else if (this.type == Type.LIST) {
            JSON.serializeList(this.list, builder);
        } else {
            throw new IllegalArgumentException("JSON\u7c7b\u578b\u9519\u8bef\uff1a" + this.type);
        }
        return builder.toString();
    }

    private static final void serializeMap(Map<?, ?> map, StringBuilder builder) {
        Objects.requireNonNull(map, "JSON\u5e8f\u5217\u5316Map\u5931\u8d25");
        builder.append('{');
        if (!map.isEmpty()) {
            map.forEach((key, value) -> {
                JSON.serializeValue(key, builder);
                builder.append(':');
                JSON.serializeValue(value, builder);
                builder.append(',');
            });
            builder.setLength(builder.length() - 1);
        }
        builder.append('}');
    }

    private static final void serializeList(List<?> list, StringBuilder builder) {
        Objects.requireNonNull(list, "JSON\u5e8f\u5217\u5316List\u5931\u8d25");
        builder.append('[');
        if (!list.isEmpty()) {
            list.forEach(value -> {
                JSON.serializeValue(value, builder);
                builder.append(',');
            });
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
    }

    private static final void serializeValue(Object object, StringBuilder builder) {
        if (object instanceof String) {
            String string = (String)object;
            builder.append('\"').append((CharSequence)JSON.escapeValue(string)).append('\"');
        } else if (object instanceof Number) {
            builder.append(object.toString());
        } else if (object instanceof Boolean) {
            builder.append(object.toString());
        } else if (object instanceof JSON) {
            builder.append(object.toString());
        } else if (object instanceof Map) {
            Map map = (Map)object;
            JSON.serializeMap(map, builder);
        } else if (object instanceof List) {
            List list = (List)object;
            JSON.serializeList(list, builder);
        } else if (object == null) {
            builder.append("null");
        } else {
            builder.append('\"').append((CharSequence)JSON.escapeValue(object.toString())).append('\"');
        }
    }

    private void deserialize(String content) {
        if (this.type == Type.MAP) {
            this.map = new LinkedHashMap<Object, Object>();
            JSON.deserializeMap(content, this.map);
        } else if (this.type == Type.LIST) {
            this.list = new ArrayList<Object>();
            JSON.deserializeList(content, this.list);
        } else {
            throw new IllegalArgumentException("JSON\u7c7b\u578b\u9519\u8bef\uff1a" + this.type);
        }
    }

    private static final void deserializeMap(String content, Map<Object, Object> map) {
        content = JSON.unescapeValue(content);
        int length = content.length();
        AtomicInteger index = new AtomicInteger(0);
        while (index.get() < length) {
            map.put(JSON.deserializeValue(index, content), JSON.deserializeValue(index, content));
        }
    }

    private static final void deserializeList(String content, List<Object> list) {
        content = JSON.unescapeValue(content);
        int length = content.length();
        AtomicInteger index = new AtomicInteger(0);
        while (index.get() < length) {
            list.add(JSON.deserializeValue(index, content));
        }
    }

    private static final Object deserializeValue(AtomicInteger index, String content) {
        int jsonIndex = 0;
        int stringIndex = 0;
        int length = content.length();
        StringBuilder builder = new StringBuilder();
        do {
            char value;
            if ((value = content.charAt(index.get())) == '\"') {
                stringIndex = stringIndex == 0 ? ++stringIndex : --stringIndex;
            } else if (value == '{' || value == '[') {
                ++jsonIndex;
            } else if (value == '}' || value == ']') {
                --jsonIndex;
            }
            if (jsonIndex == 0 && stringIndex == 0 && (value == ':' || value == ',')) {
                index.incrementAndGet();
                break;
            }
            if (value == '\\') {
                value = content.charAt(index.incrementAndGet());
                switch (value) {
                    case 'b': {
                        builder.append('\b');
                        break;
                    }
                    case 't': {
                        builder.append('\t');
                        break;
                    }
                    case 'n': {
                        builder.append('\n');
                        break;
                    }
                    case 'f': {
                        builder.append('\f');
                        break;
                    }
                    case 'r': {
                        builder.append('\r');
                        break;
                    }
                    case '\"': 
                    case '\\': {
                        if (jsonIndex != 0) {
                            builder.append('\\');
                        }
                        builder.append(value);
                        break;
                    }
                    case 'u': {
                        String hexValue = content.substring(index.get() + 1, index.get() + 5);
                        builder.append((char)Integer.parseInt(hexValue, 16));
                        index.addAndGet(4);
                        break;
                    }
                    default: {
                        builder.append('\\');
                        builder.append(value);
                        break;
                    }
                }
                continue;
            }
            builder.append(value);
        } while (index.incrementAndGet() < length);
        return JSON.deserializeValue(builder.toString());
    }

    private static final Object deserializeValue(String content) {
        String value = content.strip();
        int length = value.length();
        int aChar = 48;
        int zChar = 48;
        if (length > 1) {
            aChar = value.charAt(0);
            zChar = value.charAt(length - 1);
        }
        if (aChar == 34 && zChar == 34) {
            return value.substring(1, length - 1);
        }
        if (aChar == 123 && zChar == 125 || aChar == 91 && zChar == 93) {
            if (lazy) {
                return value;
            }
            return JSON.ofString(value);
        }
        if ("true".equals(value) || "false".equals(value)) {
            return Boolean.valueOf(value);
        }
        if ("null".equals(value)) {
            return null;
        }
        if (StringUtils.isNumeric(value)) {
            return Long.valueOf(value);
        }
        if (StringUtils.isDecimal(value)) {
            return Double.valueOf(value);
        }
        throw new IllegalArgumentException("JSON\u683c\u5f0f\u9519\u8bef\uff1a" + value);
    }

    private static final StringBuilder escapeValue(String content) {
        char[] chars = content.toCharArray();
        StringBuilder builder = new StringBuilder();
        for (char value : chars) {
            if (value > '\u001f' && value != '\"' && value != '\\') {
                builder.append(value);
                continue;
            }
            builder.append(CHARS_ESCAPE[ArrayUtils.indexOf(CHARS, value)]);
        }
        return builder;
    }

    private static final String unescapeValue(String content) {
        if (content.charAt(0) == '\\') {
            for (int index = 0; index < CHARS_ESCAPE.length; ++index) {
                content = content.replace(CHARS_ESCAPE[index], String.valueOf(CHARS[index]));
            }
        }
        return content;
    }

    public Map<Object, Object> getMap() {
        return this.map;
    }

    public List<Object> getList() {
        return this.list;
    }

    public JSON getJSON(Object key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof JSON) {
            JSON json = (JSON)value;
            return json;
        }
        if (value instanceof String) {
            String string = (String)value;
            return JSON.ofString(string);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return JSON.ofMap(map);
        }
        if (value instanceof List) {
            List list = (List)value;
            return JSON.ofList(list);
        }
        throw new IllegalArgumentException("JSON\u8f6c\u6362\u9519\u8bef\uff1a" + value);
    }

    public Integer getInteger(Object key) {
        return (Integer)this.get(key);
    }

    public Boolean getBoolean(Object key) {
        return (Boolean)this.get(key);
    }

    public String getString(Object key) {
        return (String)this.get(key);
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public Integer getInteger(int index) {
        return (Integer)this.get(index);
    }

    public Boolean getBoolean(int index) {
        return (Boolean)this.get(index);
    }

    public String getString(int index) {
        return (String)this.get(index);
    }

    public Object get(int index) {
        return this.list.get(index);
    }

    public String toJSON() {
        return this.serialize();
    }

    public String toString() {
        return this.serialize();
    }

    public static enum Type {
        MAP,
        LIST;

    }
}

