/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.format;

import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public final class XML {
    private static final Logger LOGGER = LoggerFactory.getLogger(XML.class);
    private static final String DOM_FORMAT_PRETTY_PRINT = "format-pretty-print";
    private Document document;

    private XML() {
    }

    public static final XML build() {
        XML xml = new XML();
        DocumentBuilderFactory factory = XML.buildFactory();
        try {
            xml.document = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("\u65b0\u5efaXML\u5f02\u5e38", e);
        }
        return xml;
    }

    public static final XML load(String content) {
        Objects.requireNonNull(content, "XML\u5185\u5bb9\u4e3a\u7a7a");
        XML xml = new XML();
        DocumentBuilderFactory factory = XML.buildFactory();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            xml.document = builder.parse(new ByteArrayInputStream(content.getBytes()));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.error("\u89e3\u6790XML\u5f02\u5e38\uff1a{}", content, e);
        }
        return xml;
    }

    public static final XML loadFile(String filePath) {
        String content = null;
        try {
            content = Files.readString(Paths.get(filePath, new String[0]));
        }
        catch (IOException e) {
            LOGGER.error("\u8bfb\u53d6XML\u5185\u5bb9\u5f02\u5e38\uff1a{}", filePath, e);
        }
        return XML.load(content);
    }

    private static final DocumentBuilderFactory buildFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("\u65b0\u5efaDocumentBuilderFactory\u5f02\u5e38", e);
        }
        return factory;
    }

    public Document document() {
        return this.document;
    }

    public Element element(Node node, String name) {
        return this.element(node, name, null);
    }

    public Element element(Node node, String name, String text) {
        return this.elementNS(node, name, text, null);
    }

    public Element elementNS(Node node, String name, String namespaceURI) {
        return this.elementNS(node, name, null, namespaceURI);
    }

    public Element elementNS(Node node, String name, String text, String namespaceURI) {
        Objects.requireNonNull(node, "\u4e0a\u7ea7\u8282\u70b9\u4e3a\u7a7a");
        Element element = null;
        element = StringUtils.isEmpty(namespaceURI) ? this.document.createElement(name) : this.document.createElementNS(namespaceURI, name);
        if (StringUtils.isNotEmpty(text)) {
            element.setTextContent(text);
        }
        node.appendChild(element);
        return element;
    }

    public String elementValue(String name) {
        NodeList list = this.document.getElementsByTagName(name);
        if (list.getLength() == 0) {
            return null;
        }
        return list.item(0).getTextContent();
    }

    public List<String> elementValues(String name) {
        NodeList list = this.document.getElementsByTagName(name);
        int length = list.getLength();
        if (length == 0) {
            return List.of();
        }
        ArrayList<String> values = new ArrayList<String>(length);
        for (int index = 0; index < length; ++index) {
            values.add(list.item(index).getTextContent());
        }
        return values;
    }

    public String xml() {
        return this.xml(false);
    }

    public String xml(boolean format) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            DOMConfiguration configuration;
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSOutput output = domImplementation.createLSOutput();
            LSSerializer serializer = domImplementation.createLSSerializer();
            output.setEncoding("UTF-8");
            output.setCharacterStream(writer);
            if (format && (configuration = serializer.getDomConfig()).canSetParameter(DOM_FORMAT_PRETTY_PRINT, true)) {
                configuration.setParameter(DOM_FORMAT_PRETTY_PRINT, true);
            }
            serializer.write(this.document, output);
            string = ((Object)writer).toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Writer)writer).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOGGER.error("\u8f93\u51faXML\u5f02\u5e38", e);
                return null;
            }
        }
        ((Writer)writer).close();
        return string;
    }
}

