/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.gui;

import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.context.IContext;
import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.gui.event.GuiEvent;
import com.acgist.snail.gui.event.adapter.AlertEventAdapter;
import com.acgist.snail.gui.event.adapter.BuildEventAdapter;
import com.acgist.snail.gui.event.adapter.ExitEventAdapter;
import com.acgist.snail.gui.event.adapter.HideEventAdapter;
import com.acgist.snail.gui.event.adapter.MultifileEventAdapter;
import com.acgist.snail.gui.event.adapter.NoticeEventAdapter;
import com.acgist.snail.gui.event.adapter.RefreshTaskListEventAdapter;
import com.acgist.snail.gui.event.adapter.RefreshTaskStatusEventAdapter;
import com.acgist.snail.gui.event.adapter.ResponseEventAdapter;
import com.acgist.snail.gui.event.adapter.ShowEventAdapter;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.IMessageSender;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.application.ApplicationMessage;
import com.acgist.snail.utils.ArrayUtils;
import com.acgist.snail.utils.StringUtils;
import java.util.EnumMap;
import java.util.Map;

public final class GuiContext
implements IContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuiContext.class);
    private static final GuiContext INSTANCE = new GuiContext();
    private static final String ARGS_MODE = "mode";
    private Mode mode = Mode.NATIVE;
    private IMessageSender extendGuiMessageSender;
    private final Object lock = new Object();
    private final Map<GuiEvent.Type, GuiEvent> eventMapping = new EnumMap<GuiEvent.Type, GuiEvent>(GuiEvent.Type.class);

    public static final GuiContext getInstance() {
        return INSTANCE;
    }

    private GuiContext() {
    }

    public static final void register(GuiEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u6ce8\u518cGUI\u4e8b\u4ef6\uff1a{} - {}", new Object[]{event.getType(), event.getName()});
        }
        GuiContext.INSTANCE.eventMapping.put(event.getType(), event);
    }

    public static final void registerAdapter() {
        GuiContext.register(new ShowEventAdapter());
        GuiContext.register(new HideEventAdapter());
        GuiContext.register(new ExitEventAdapter());
        GuiContext.register(new BuildEventAdapter());
        GuiContext.register(new AlertEventAdapter());
        GuiContext.register(new NoticeEventAdapter());
        GuiContext.register(new ResponseEventAdapter());
        GuiContext.register(new MultifileEventAdapter());
        GuiContext.register(new RefreshTaskListEventAdapter());
        GuiContext.register(new RefreshTaskStatusEventAdapter());
    }

    public GuiContext init(String ... args) {
        if (ArrayUtils.isEmpty(args)) {
            LOGGER.debug("\u6ca1\u6709\u8bbe\u7f6e\u542f\u52a8\u53c2\u6570", new Object[0]);
        } else {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\u542f\u52a8\u53c2\u6570\uff1a{}", SymbolConfig.Symbol.COMMA.join(args));
            }
            Map<String, String> argsMap = StringUtils.argsMap(args);
            String mode = argsMap.get(ARGS_MODE);
            this.mode = Mode.of(mode);
            LOGGER.debug("\u8fd0\u884c\u6a21\u5f0f\uff1a{}", new Object[]{this.mode});
        }
        if (this.mode == Mode.EXTEND) {
            LOGGER.debug("\u6269\u5c55GUI\u6ce8\u518c\u4e8b\u4ef6\u4ee3\u7406", new Object[0]);
            GuiContext.registerAdapter();
        }
        return this;
    }

    public GuiContext show() {
        return this.event(GuiEvent.Type.SHOW, new Object[0]);
    }

    public GuiContext hide() {
        return this.event(GuiEvent.Type.HIDE, new Object[0]);
    }

    public GuiContext exit() {
        return this.event(GuiEvent.Type.EXIT, new Object[0]);
    }

    public GuiContext build() {
        return this.event(GuiEvent.Type.BUILD, new Object[0]);
    }

    public GuiContext alert(String title, String message) {
        return this.alert(title, message, MessageType.INFO);
    }

    public GuiContext alert(String title, String message, MessageType type) {
        return this.event(GuiEvent.Type.ALERT, new Object[]{title, message, type});
    }

    public GuiContext notice(String title, String message) {
        return this.notice(title, message, MessageType.INFO);
    }

    public GuiContext notice(String title, String message, MessageType type) {
        return this.event(GuiEvent.Type.NOTICE, new Object[]{title, message, type});
    }

    public GuiContext multifile(ITaskSession taskSession) {
        return this.event(GuiEvent.Type.MULTIFILE, taskSession);
    }

    public GuiContext refreshTaskList() {
        return this.event(GuiEvent.Type.REFRESH_TASK_LIST, new Object[0]);
    }

    public GuiContext refreshTaskStatus(Object ... args) {
        return this.event(GuiEvent.Type.REFRESH_TASK_STATUS, args);
    }

    public GuiContext response(String message) {
        return this.event(GuiEvent.Type.RESPONSE, message);
    }

    public GuiContext event(GuiEvent.Type type, Object ... args) {
        if (type == null) {
            LOGGER.warn("\u9519\u8befGUI\u4e8b\u4ef6\uff1a{}", new Object[]{type});
            return this;
        }
        GuiEvent event = this.eventMapping.get((Object)type);
        if (event == null) {
            LOGGER.warn("\u672a\u77e5GUI\u4e8b\u4ef6\uff1a{}", new Object[]{type});
            return this;
        }
        LOGGER.debug("\u6267\u884cGUI\u4e8b\u4ef6\uff1a{}", new Object[]{type});
        event.execute(this.mode, args);
        return this;
    }

    public boolean extendGuiMessageHandler(IMessageSender extendGuiMessageSender) {
        if (this.mode == Mode.NATIVE) {
            LOGGER.debug("\u5ffd\u7565\u6ce8\u518c\u6269\u5c55GUI\u6d88\u606f\u4ee3\u7406\uff1a\u5df2\u7ecf\u542f\u7528\u672c\u5730GUI", new Object[0]);
            return false;
        }
        LOGGER.debug("\u6ce8\u518c\u6269\u5c55GUI\u6d88\u606f\u4ee3\u7406", new Object[0]);
        this.extendGuiMessageSender = extendGuiMessageSender;
        return true;
    }

    public void sendExtendGuiMessage(ApplicationMessage message) {
        if (message == null) {
            LOGGER.warn("\u6269\u5c55GUI\u6d88\u606f\u9519\u8bef\uff1a{}", message);
            return;
        }
        if (this.extendGuiMessageSender != null) {
            try {
                this.extendGuiMessageSender.send(message.toString());
            }
            catch (NetException e) {
                LOGGER.error("\u53d1\u9001\u6269\u5c55GUI\u6d88\u606f\u5f02\u5e38", e);
            }
        } else {
            LOGGER.warn("\u6269\u5c55GUI\u6d88\u606f\u4ee3\u7406\u6ca1\u6709\u6ce8\u518c", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait(Long.MAX_VALUE);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.debug("\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public static enum Mode {
        NATIVE,
        EXTEND;


        public static final Mode of(String mode) {
            Mode[] values;
            for (Mode value : values = Mode.values()) {
                if (!value.name().equalsIgnoreCase(mode)) continue;
                return value;
            }
            return NATIVE;
        }
    }

    public static enum MessageType {
        NONE,
        INFO,
        WARN,
        ERROR,
        CONFIRM;


        public static final MessageType of(String value) {
            MessageType[] types;
            for (MessageType type : types = MessageType.values()) {
                if (!type.name().equalsIgnoreCase(value)) continue;
                return type;
            }
            return null;
        }
    }
}

