/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.gui;

import com.acgist.snail.format.BEncodeDecoder;
import com.acgist.snail.gui.GuiContext;
import com.acgist.snail.net.PacketSizeException;
import com.acgist.snail.net.application.ApplicationMessage;

public record GuiMessage(GuiContext.MessageType type, String title, String message) {
    public static final GuiMessage of(ApplicationMessage message) throws PacketSizeException {
        String body = message.getBody();
        BEncodeDecoder decoder = BEncodeDecoder.newInstance(body).next();
        if (decoder.isEmpty()) {
            return null;
        }
        String type = decoder.getString("type");
        String title = decoder.getString("title");
        String content = decoder.getString("message");
        return new GuiMessage(GuiContext.MessageType.of(type), title, content);
    }
}

