/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.gui.event;

import com.acgist.snail.gui.GuiContext;
import com.acgist.snail.net.application.ApplicationMessage;

public abstract class GuiEvent {
    protected final Type type;
    protected final String name;

    protected GuiEvent(Type type, String name) {
        this.type = type;
        this.name = name;
    }

    public final void execute(GuiContext.Mode mode, Object ... args) {
        if (mode == GuiContext.Mode.NATIVE) {
            this.executeNative(args);
        } else {
            this.executeExtend(args);
        }
    }

    protected void sendExtendGuiMessage(ApplicationMessage message) {
        GuiContext.getInstance().sendExtendGuiMessage(message);
    }

    protected abstract void executeNative(Object ... var1);

    protected abstract void executeExtend(Object ... var1);

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public static enum Type {
        SHOW,
        HIDE,
        EXIT,
        BUILD,
        ALERT,
        NOTICE,
        MULTIFILE,
        REFRESH_TASK_LIST,
        REFRESH_TASK_STATUS,
        RESPONSE;

    }
}

