/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.gui.event;

import com.acgist.snail.format.BEncodeEncoder;
import com.acgist.snail.gui.GuiContext;
import com.acgist.snail.gui.event.GuiEvent;
import com.acgist.snail.gui.event.GuiEventArgs;
import com.acgist.snail.net.application.ApplicationMessage;
import java.util.Map;

public abstract class GuiEventMessage
extends GuiEventArgs {
    public static final String TASK_ID = "id";
    public static final String TASK_STATUS = "status";
    public static final String MESSAGE_TYPE = "type";
    public static final String MESSAGE_TITLE = "title";
    public static final String MESSAGE_MESSAGE = "message";
    protected final ApplicationMessage.Type messageType;

    protected GuiEventMessage(GuiEvent.Type type, String name, ApplicationMessage.Type messageType) {
        super(type, name);
        this.messageType = messageType;
    }

    @Override
    protected final void executeExtend(GuiContext.Mode mode, Object ... args) {
        if (!this.check(args, 2, 3)) {
            return;
        }
        String title = (String)this.getArg(args, 0);
        String message = (String)this.getArg(args, 1);
        GuiContext.MessageType type = (GuiContext.MessageType)((Object)this.getArg(args, 2, (Object)GuiContext.MessageType.INFO));
        if (mode == GuiContext.Mode.NATIVE) {
            this.executeNativeExtend(type, title, message);
        } else {
            this.executeExtendExtend(type, title, message);
        }
    }

    protected void executeNativeExtend(GuiContext.MessageType type, String title, String message) {
        this.executeExtendExtend(type, title, message);
    }

    protected void executeExtendExtend(GuiContext.MessageType type, String title, String message) {
        Map<String, String> map = Map.of(MESSAGE_TYPE, type.name(), MESSAGE_TITLE, title, MESSAGE_MESSAGE, message);
        String body = BEncodeEncoder.encodeMapString(map);
        this.sendExtendGuiMessage(this.messageType.build(body));
    }
}

