/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.gui.event.adapter;

import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.context.wrapper.DescriptionWrapper;
import com.acgist.snail.gui.GuiContext;
import com.acgist.snail.gui.event.GuiEvent;
import com.acgist.snail.gui.event.GuiEventArgs;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.net.application.ApplicationMessage;
import com.acgist.snail.net.torrent.Torrent;
import com.acgist.snail.net.torrent.TorrentContext;
import com.acgist.snail.net.torrent.TorrentFile;
import com.acgist.snail.net.torrent.TorrentFileMatedata;
import com.acgist.snail.utils.ModifyOptional;
import com.acgist.snail.utils.StringUtils;
import java.util.List;
import java.util.stream.Collectors;

public class MultifileEventAdapter
extends GuiEventArgs {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifileEventAdapter.class);
    private static final ModifyOptional<String> FILES = ModifyOptional.newInstance();

    public MultifileEventAdapter() {
        super(GuiEvent.Type.MULTIFILE, "\u9009\u62e9\u4e0b\u8f7d\u6587\u4ef6\u4e8b\u4ef6");
    }

    @Override
    protected final void executeExtend(GuiContext.Mode mode, Object ... args) {
        if (!this.check(args, 1)) {
            return;
        }
        ITaskSession taskSession = (ITaskSession)this.getArg(args, 0);
        if (mode == GuiContext.Mode.NATIVE) {
            this.executeNativeExtend(taskSession);
        } else {
            this.executeExtendExtend(taskSession);
        }
    }

    protected void executeNativeExtend(ITaskSession taskSession) {
        this.executeExtendExtend(taskSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeExtendExtend(ITaskSession taskSession) {
        String files = null;
        try {
            Torrent torrent = TorrentContext.getInstance().newTorrentSession(taskSession.getTorrent()).torrent();
            while (StringUtils.isEmpty(files = FILES.get())) {
                List<String> downloadList = torrent.getInfo().files().stream().filter(TorrentFile::notPaddingFile).map(TorrentFile::path).collect(Collectors.toList());
                String downloadFiles = DescriptionWrapper.newEncoder(downloadList).serialize();
                this.sendExtendGuiMessage(ApplicationMessage.Type.MULTIFILE.build(downloadFiles));
                MultifileEventAdapter.waitForFiles();
            }
            List selectFiles = DescriptionWrapper.newDecoder(files).deserialize().stream().map(StringUtils::getString).collect(Collectors.toList());
            long size = torrent.getInfo().files().stream().filter(file -> selectFiles.contains(file.path())).collect(Collectors.summingLong(TorrentFileMatedata::getLength));
            taskSession.setSize(size);
            taskSession.setDescription(files);
        }
        catch (DownloadException e) {
            LOGGER.error("\u8bbe\u7f6e\u9009\u62e9\u4e0b\u8f7d\u6587\u4ef6\u5217\u8868\u5f02\u5e38\uff1a{}", files, e);
        }
        finally {
            FILES.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void waitForFiles() {
        ModifyOptional<String> modifyOptional = FILES;
        synchronized (modifyOptional) {
            try {
                FILES.wait(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.error("\u7b49\u5f85\u8bbe\u7f6e\u9009\u62e9\u4e0b\u8f7d\u6587\u4ef6\u5217\u8868\u5f02\u5e38", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void files(String files) {
        FILES.set(files);
        ModifyOptional<String> modifyOptional = FILES;
        synchronized (modifyOptional) {
            FILES.notifyAll();
        }
    }
}

