/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.gui.recycle;

import com.acgist.snail.context.IContext;
import com.acgist.snail.context.SystemContext;
import com.acgist.snail.gui.recycle.Recycle;
import com.acgist.snail.gui.recycle.local.LinuxRecycle;
import com.acgist.snail.gui.recycle.local.MacRecycle;
import com.acgist.snail.gui.recycle.local.WindowsRecycle;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.utils.StringUtils;
import java.util.function.Function;

public final class RecycleContext
implements IContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecycleContext.class);
    private static final Function<String, Recycle> BUILDER;

    private RecycleContext() {
    }

    public static final Recycle newInstance(String path) {
        if (BUILDER == null) {
            return null;
        }
        return BUILDER.apply(path);
    }

    public static final boolean recycle(String path) {
        if (StringUtils.isEmpty(path)) {
            LOGGER.warn("\u56de\u6536\u7ad9\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff08\u8def\u5f84\u9519\u8bef\uff09\uff1a{}", path);
            return false;
        }
        Recycle recycle = RecycleContext.newInstance(path);
        if (recycle == null) {
            LOGGER.debug("\u56de\u6536\u7ad9\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff08\u4e0d\u652f\u6301\uff09\uff1a{}", path);
            return false;
        }
        return recycle.delete();
    }

    static {
        SystemContext.SystemType systemType = SystemContext.SystemType.local();
        LOGGER.debug("\u521d\u59cb\u5316\u7cfb\u7edf\u56de\u6536\u7ad9\uff1a{}", new Object[]{systemType});
        if (systemType == SystemContext.SystemType.WINDOWS) {
            BUILDER = WindowsRecycle::new;
        } else if (systemType == SystemContext.SystemType.LINUX) {
            BUILDER = LinuxRecycle::new;
        } else if (systemType == SystemContext.SystemType.MAC) {
            BUILDER = MacRecycle::new;
        } else {
            LOGGER.warn("\u7cfb\u7edf\u4e0d\u652f\u6301\u56de\u6536\u7ad9\uff1a{}", new Object[]{systemType});
            BUILDER = null;
        }
    }
}

