/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.gui.recycle.local;

import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.gui.recycle.Recycle;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.utils.DateUtils;
import com.acgist.snail.utils.FileUtils;
import com.acgist.snail.utils.NumberUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Paths;

public final class WindowsRecycle
extends Recycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowsRecycle.class);
    private static final String FILE_PREFIX = "$R";
    private static final String INFO_PREFIX = "$I";
    private static final String RECYCLE_FOLDER = "$RECYCLE.BIN";
    private String recyclePath;
    private String deleteFilePath;
    private String deleteInfoFilePath;

    public WindowsRecycle(String path) {
        super(path);
        this.buildRecyclePath();
        this.buildRecycleInfo();
    }

    private void buildRecyclePath() {
        File[] files;
        String disk = this.disk(this.path);
        String recycleFolder = FileUtils.file(disk, RECYCLE_FOLDER);
        File recycleFile = new File(recycleFolder);
        if (!recycleFile.exists()) {
            throw new IllegalArgumentException("\u56de\u6536\u7ad9\u4e0a\u7ea7\u76ee\u5f55\u4e0d\u5b58\u5728\uff1a" + recycleFolder);
        }
        for (File file : files = recycleFile.listFiles()) {
            if (file.listFiles() == null) continue;
            this.recyclePath = file.getAbsolutePath();
            LOGGER.debug("\u56de\u6536\u7ad9\u8def\u5f84\uff1a{}", this.recyclePath);
            break;
        }
    }

    private String disk(String filePath) {
        int diskIndex = filePath.indexOf(SymbolConfig.Symbol.COLON.toChar());
        if (diskIndex < 0) {
            String absolutePath = Paths.get(filePath, new String[0]).toFile().getAbsolutePath();
            return this.disk(absolutePath);
        }
        return filePath.substring(0, diskIndex + 1).toUpperCase();
    }

    private void buildRecycleInfo() {
        String ext;
        String name = NumberUtils.build().toString();
        if (this.file.isFile() && (ext = FileUtils.fileExt(this.path)) != null) {
            name = SymbolConfig.Symbol.DOT.join(name, ext);
        }
        this.deleteFilePath = FileUtils.file(this.recyclePath, FILE_PREFIX + name);
        this.deleteInfoFilePath = FileUtils.file(this.recyclePath, INFO_PREFIX + name);
        LOGGER.debug("\u5220\u9664\u6587\u4ef6\u8def\u5f84\uff1a{}\n\u5220\u9664\u4fe1\u606f\u6587\u4ef6\u8def\u5f84\uff1a{}\n", this.deleteFilePath, this.deleteInfoFilePath);
    }

    private boolean deleteFile() {
        return this.file.renameTo(new File(this.deleteFilePath));
    }

    private void buildDeleteInfoFile() {
        try {
            FileUtils.write(this.deleteInfoFilePath, this.buildDeleteInfo());
        }
        catch (IOException e) {
            LOGGER.error("\u65b0\u5efa\u5220\u9664\u4fe1\u606f\u6587\u4ef6\u5f02\u5e38", e);
        }
    }

    private byte[] buildDeleteInfo() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        String path = FileUtils.systemSeparator(this.path);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        buffer.order(ByteOrder.nativeOrder());
        out.write(2);
        out.write(new byte[7]);
        buffer.putLong(FileUtils.fileSize(this.deleteFilePath));
        out.write(buffer.array());
        buffer.clear();
        buffer.putLong(DateUtils.windowsTimestamp());
        out.write(buffer.array());
        buffer.clear();
        char length = (char)(1 + path.length());
        this.buildInfoChar(out, length);
        out.write(new byte[2]);
        for (int index = 0; index < path.length(); ++index) {
            this.buildInfoChar(out, path.charAt(index));
        }
        out.write(new byte[2]);
        return out.toByteArray();
    }

    private void buildInfoChar(ByteArrayOutputStream out, char value) {
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            out.write(value & 0xFF);
            out.write(value >> 8 & 0xFF);
        } else {
            out.write(value >> 8 & 0xFF);
            out.write(value & 0xFF);
        }
    }

    @Override
    public boolean delete() {
        LOGGER.info("\u56de\u6536\u6587\u4ef6\uff1a{} - {}", this.path, this.deleteFilePath);
        if (this.deleteFile()) {
            this.buildDeleteInfoFile();
            return true;
        }
        return false;
    }
}

