/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.logger;

import com.acgist.snail.logger.Level;
import com.acgist.snail.logger.LoggerAdapter;
import com.acgist.snail.logger.LoggerConfig;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.logger.Tuple;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Logger {
    private static final int DEFAULT_CAPACITY = 128;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final int level;
    private final String name;
    private final String nameFormat;
    private final String system;
    private final String systemFormat;
    private final List<LoggerAdapter> adapters;
    private final Map<String, Tuple> tupleMap;

    public Logger(String name) {
        this.name = name;
        this.nameFormat = String.format(" %s ", this.buildSimpleName(this.name));
        this.level = LoggerConfig.getLevel();
        this.system = LoggerConfig.getSystem();
        this.systemFormat = String.format("[%s] ", this.system);
        this.adapters = LoggerFactory.getAdapters();
        this.tupleMap = new ConcurrentHashMap<String, Tuple>();
    }

    private String format(Level level, String format, Object ... args) {
        Tuple tuple = this.tupleMap.computeIfAbsent(format, Tuple::new);
        StringBuilder builder = new StringBuilder(128);
        builder.append(this.systemFormat).append(DATE_TIME_FORMATTER.format(LocalDateTime.now())).append(" [").append(Thread.currentThread().getName()).append("] ").append((Object)level).append(this.nameFormat);
        tuple.format(builder, args).append("\n");
        Throwable throwable = tuple.throwable(args);
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            builder.append(stringWriter.toString()).append("\n");
        }
        return builder.toString();
    }

    private boolean isEnabled(Level level) {
        return this.level <= level.value();
    }

    private void log(Level level, String format, Object ... args) {
        if (this.isEnabled(level)) {
            boolean error;
            String message = this.format(level, format, args);
            boolean bl = error = level.value() >= Level.ERROR.value();
            if (error) {
                this.adapters.forEach(adapter -> adapter.errorOutput(message));
            } else {
                this.adapters.forEach(adapter -> adapter.output(message));
            }
        }
    }

    public String buildSimpleName(String name) {
        int old;
        int index = 0;
        int dot = 46;
        StringBuilder builder = new StringBuilder();
        while ((old = name.indexOf(46, index)) != -1) {
            builder.append(name.substring(index, index + 1)).append('.');
            index = old + 1;
        }
        builder.append(name.substring(index));
        return builder.toString();
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    public void debug(String format, Object ... args) {
        this.log(Level.DEBUG, format, args);
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO);
    }

    public void info(String format, Object ... args) {
        this.log(Level.INFO, format, args);
    }

    public boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN);
    }

    public void warn(String format, Object ... args) {
        this.log(Level.WARN, format, args);
    }

    public boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR);
    }

    public void error(String format, Object ... args) {
        this.log(Level.ERROR, format, args);
    }
}

