/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.logger;

import com.acgist.snail.logger.LoggerFactory;
import java.io.IOException;
import java.io.OutputStream;

public abstract class LoggerAdapter {
    private volatile boolean available = true;
    protected OutputStream output;
    protected OutputStream errorOutput;

    protected LoggerAdapter() {
    }

    protected LoggerAdapter(OutputStream output, OutputStream errorOutput) {
        this.output = output;
        this.errorOutput = errorOutput;
    }

    public void output(String message) {
        if (this.available) {
            try {
                this.output.write(message.getBytes());
            }
            catch (IOException e) {
                LoggerFactory.error(e);
            }
        }
    }

    public void errorOutput(String message) {
        if (this.available) {
            try {
                this.errorOutput.write(message.getBytes());
            }
            catch (IOException e) {
                LoggerFactory.error(e);
            }
        }
    }

    public void release() {
        boolean closeErrorOutput;
        this.available = false;
        boolean bl = closeErrorOutput = this.output != this.errorOutput;
        if (this.output != null) {
            try {
                this.output.flush();
                this.output.close();
            }
            catch (IOException e) {
                LoggerFactory.error(e);
            }
        }
        if (closeErrorOutput && this.errorOutput != null) {
            try {
                this.errorOutput.flush();
                this.errorOutput.close();
            }
            catch (IOException e) {
                LoggerFactory.error(e);
            }
        }
    }
}

