/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.logger;

import com.acgist.snail.logger.Level;
import com.acgist.snail.logger.LoggerFactory;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

public final class LoggerConfig {
    private static final LoggerConfig INSTANCE = new LoggerConfig();
    private static final String LOGGER_CONFIG = "/logger.properties";
    private int level;
    private String system;
    private String adapter;
    private String fileName;
    private int fileBuffer;
    private int fileMaxDays;

    public static final LoggerConfig getInstance() {
        return INSTANCE;
    }

    private LoggerConfig() {
    }

    private void init() {
        Properties properties = new Properties();
        try (InputStreamReader reader = new InputStreamReader(LoggerConfig.class.getResourceAsStream(LOGGER_CONFIG), StandardCharsets.UTF_8);){
            properties.load(reader);
        }
        catch (IOException e) {
            LoggerFactory.error(e);
        }
        this.level = Level.of(properties.getProperty("logger.level")).value();
        this.system = properties.getProperty("logger.system");
        this.adapter = properties.getProperty("logger.adapter");
        this.fileName = properties.getProperty("logger.file.name");
        this.fileBuffer = Integer.parseInt(properties.getProperty("logger.file.buffer", "8192"));
        this.fileMaxDays = Integer.parseInt(properties.getProperty("logger.file.max.days", "30"));
    }

    public static final void off() {
        LoggerConfig.INSTANCE.level = Level.OFF.value();
    }

    public static final void setLevel(Level level) {
        LoggerConfig.INSTANCE.level = level.value();
    }

    public static final int getLevel() {
        return LoggerConfig.INSTANCE.level;
    }

    public static final String getSystem() {
        return LoggerConfig.INSTANCE.system;
    }

    public static final String getAdapter() {
        return LoggerConfig.INSTANCE.adapter;
    }

    public static final String getFileName() {
        return LoggerConfig.INSTANCE.fileName;
    }

    public static final int getFileBuffer() {
        return LoggerConfig.INSTANCE.fileBuffer;
    }

    public static final int getFileMaxDays() {
        return LoggerConfig.INSTANCE.fileMaxDays;
    }

    static {
        INSTANCE.init();
    }
}

